/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.expression.Expression;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.util.SpelUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IComboItem;
import pl.fhframework.model.forms.Table;

public abstract class BaseInputListField
extends BaseInputField {
    private static final String VALUES_ATTR = "values";
    private static final String RAW_OPTIONS_ATTR = "rawOptions";
    protected static final String SELECTED_INDEX = "selectedIndex";
    private static final String FORMATTER_ATTR = "formatter";
    private static final String EMPTY_VALUE_ATTR = "emptyValue";
    private static final String EMPTY_LABEL_ATTR = "emptyLabel";
    private List<String> rawOptions;
    private int selectedIndex = -1;
    @JsonIgnore
    protected int newIndex = 0;
    @JsonIgnore
    private List<?> currentlyCalculatedValues;
    @JsonIgnore
    @XMLProperty(value="values")
    @DesignerXMLProperty(priority=90, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, commonUse=true)
    private ModelBinding listBinding;
    @JsonIgnore
    protected List<?> presentedValues;
    @JsonIgnore
    @XMLProperty(value="formatter")
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(priority=100)
    private String formatter;
    private boolean emptyValue;
    @JsonIgnore
    @XMLProperty(value="emptyValue")
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if value passed can be empty", boundable=true)
    private ModelBinding<Boolean> emptyValueBinding;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Determines if empty value should be displayed on list of options.")
    @DesignerXMLProperty(priority=60, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    protected boolean emptyLabel;
    @JsonIgnore
    @XMLProperty(aliases={"displayAttribute"})
    @DesignerXMLProperty(priority=79, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, commonUse=true)
    @DocumentedComponentAttribute(value="Defines an attribute of a single value object to be used for display. If not set, converter will be used.")
    private String displayExpression;
    @JsonIgnore
    private Function<Object, Object> displayExpressionFunction;

    public BaseInputListField(Form form) {
        super(form);
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        if (this.getModelBinding() != null) {
            Object chosenObject = this.getChosenObjectAndSetIndex(valueChange.getMainValue());
            this.getModelBinding().setValue(chosenObject);
        }
    }

    protected Object getChosenObjectAndSetIndex(String newValue) {
        this.newIndex = !StringUtils.isNullOrEmpty((String)newValue) ? Integer.parseInt(newValue) : -1;
        return this.newIndex >= 0 ? this.presentedValues.get(this.newIndex) : null;
    }

    protected boolean areValuesEqual(List<String> list1, List<String> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        int size = list1.size();
        for (int i = 0; i < size; ++i) {
            if (this.areValuesTheSame(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ElementChanges updateView() {
        ModelBinding modelBinding;
        ElementChanges elementChanges = super.updateView();
        this.currentlyCalculatedValues = this.calculateBindingValues();
        elementChanges.setFormId(this.getForm().getId());
        elementChanges.setFormElementId(this.getId());
        if (this.emptyValueBinding != null) {
            this.emptyValue = this.emptyValueBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.emptyValue, EMPTY_VALUE_ATTR);
        }
        this.refreshAvailability(elementChanges);
        boolean shouldRefresh = false;
        List<String> newRawValues = this.calculateRawValuesCollection(this.currentlyCalculatedValues, this.formatter);
        if (!this.areValuesEqual(newRawValues, this.rawOptions)) {
            this.rawOptions = newRawValues;
            elementChanges.addChange(RAW_OPTIONS_ATTR, this.rawOptions);
            this.presentedValues = this.currentlyCalculatedValues;
            shouldRefresh = true;
        }
        if ((modelBinding = this.getModelBinding()) != null) {
            Object selectedValue;
            this.skipSettingPresentation(elementChanges, this.getForm());
            BindingResult bindingResult = modelBinding.getBindingResult();
            boolean selectedIndexUpdated = false;
            if (this.newIndex != this.selectedIndex) {
                this.selectedIndex = this.newIndex;
                selectedIndexUpdated = true;
                shouldRefresh = true;
            }
            Object v0 = selectedValue = this.selectedIndex >= 0 && this.selectedIndex < this.presentedValues.size() ? this.presentedValues.get(this.selectedIndex) : null;
            if (bindingResult != null && !this.presentedValues.isEmpty() && !this.areValuesTheSame(bindingResult.getValue(), selectedValue)) {
                this.selectedIndex = this.presentedValues.indexOf(bindingResult.getValue());
                selectedIndexUpdated = true;
                shouldRefresh = true;
            }
            if (selectedIndexUpdated) {
                elementChanges.addChange(SELECTED_INDEX, (Object)this.selectedIndex);
            }
        }
        this.prepareComponentAfterValidation(elementChanges);
        if (shouldRefresh |= this.processLabelBinding(elementChanges)) {
            this.refreshView();
        }
        return elementChanges;
    }

    protected List<?> calculateBindingValues() {
        Object value;
        BindingResult bindingResult = this.listBinding == null ? null : this.listBinding.getBindingResult();
        Object object = value = bindingResult != null ? bindingResult.getValue() : null;
        if (value == null) {
            if (this.getForm().getViewMode() == Form.ViewMode.DESIGN || this.getForm().getViewMode() == Form.ViewMode.PREVIEW) {
                return this.calculateBindingValues(Arrays.asList("Option 1", "Option 2", "Option 3"));
            }
            return this.calculateBindingValues(Collections.emptyList());
        }
        if (value instanceof String) {
            ArrayList adhoc = new ArrayList();
            String[] adhocOptions = value.toString().split("\\|");
            Collections.addAll(adhoc, adhocOptions);
            return this.calculateBindingValues(adhoc);
        }
        if (value instanceof List) {
            return this.calculateBindingValues((List)value);
        }
        throw new FhBindingException("Bound value is not a List instance!!");
    }

    protected List<?> calculateBindingValues(List<?> value) {
        LinkedList values = new LinkedList(value);
        if (this.emptyLabel) {
            values.add(0, null);
        }
        return values;
    }

    protected List<String> calculateRawValuesCollection(List<?> values, String converter) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet displayAttributeNotFound = new HashSet();
        for (Object element : values) {
            if ((element = this.maybeGetDisplayAttribute(element)) instanceof IComboItem) {
                result.add(((IComboItem)element).getTargetValue());
                continue;
            }
            result.add(this.convertValueToString(element, converter));
        }
        return result;
    }

    @JsonIgnore
    public Optional<String> getOptionalFormatter() {
        return Optional.ofNullable(this.formatter);
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField inputFieldClone) {
        super.doCopy(table, iteratorReplacements, inputFieldClone);
        BaseInputListField clone = (BaseInputListField)inputFieldClone;
        clone.setListBinding(table.getRowBinding(this.getListBinding(), (Component)clone, iteratorReplacements));
        clone.setFormatter(this.getFormatter());
        clone.setEmptyValueBinding((ModelBinding<Boolean>)table.getRowBinding(this.getEmptyValueBinding(), (Component)clone, iteratorReplacements));
        clone.setEmptyLabel(this.isEmptyLabel());
    }

    private Object maybeGetDisplayAttribute(Object element) {
        if (this.getForm().getViewMode() == Form.ViewMode.NORMAL && element != null && StringUtils.hasText((String)this.displayExpression)) {
            if (this.displayExpressionFunction == null) {
                Expression exp = SpelUtils.parseExpression((String)this.displayExpression);
                this.displayExpressionFunction = obj -> {
                    if (obj instanceof String) {
                        return obj;
                    }
                    return this.convertValueToString(SpelUtils.evaluateExpression((Expression)exp, (Object)obj));
                };
            }
            return this.displayExpressionFunction.apply(element);
        }
        return element;
    }

    @Override
    protected String convertMainValueToString(Object value, Optional<String> converterName) {
        value = this.maybeGetDisplayAttribute(value);
        return super.convertMainValueToString(value, converterName);
    }

    public List<String> getRawOptions() {
        return this.rawOptions;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public ModelBinding getListBinding() {
        return this.listBinding;
    }

    @JsonIgnore
    public void setListBinding(ModelBinding listBinding) {
        this.listBinding = listBinding;
    }

    public List<?> getPresentedValues() {
        return this.presentedValues;
    }

    public String getFormatter() {
        return this.formatter;
    }

    @JsonIgnore
    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public boolean isEmptyValue() {
        return this.emptyValue;
    }

    public ModelBinding<Boolean> getEmptyValueBinding() {
        return this.emptyValueBinding;
    }

    @JsonIgnore
    public void setEmptyValueBinding(ModelBinding<Boolean> emptyValueBinding) {
        this.emptyValueBinding = emptyValueBinding;
    }

    public boolean isEmptyLabel() {
        return this.emptyLabel;
    }

    public void setEmptyLabel(boolean emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public String getDisplayExpression() {
        return this.displayExpression;
    }

    @JsonIgnore
    public void setDisplayExpression(String displayExpression) {
        this.displayExpression = displayExpression;
    }

    public Function<Object, Object> getDisplayExpressionFunction() {
        return this.displayExpressionFunction;
    }

    @JsonIgnore
    public void setDisplayExpressionFunction(Function<Object, Object> displayExpressionFunction) {
        this.displayExpressionFunction = displayExpressionFunction;
    }
}

