/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.TabContainer;
import pl.fhframework.model.forms.Wizard;
import pl.fhframework.model.forms.attribute.Layout;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.IDesignerEventListener;

@TemplateControl(tagName="fh-tab")
@Control(parents={TabContainer.class, Wizard.class})
@DocumentedComponent(documentationExample=true, ignoreFields={"width"}, value="Tab component which represents a single tab", icon="fa fa-window-maximize")
public class Tab
extends GroupingComponent
implements IHasBoundableLabel,
IDesignerEventListener {
    public static final String ATTR_LABEL = "label";
    public static final String TYPE_NAME = "Tab";
    public static final String DEFAULT_LAYOUT = "vertical";
    private String label;
    @JsonIgnore
    @XMLProperty(value="label")
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, previewValueProvider=BindingExpressionDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(boundable=true, value="Component label")
    private ModelBinding labelModelBinding;
    @XMLProperty(defaultValue="vertical")
    private Layout layout;
    @JsonIgnore
    private boolean layoutGenerated = true;

    public Tab(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        if (this.label == null) {
            this.label = this.getId();
        }
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        boolean refreshView = this.processLabelBinding(elementChanges, false);
        if (refreshView) {
            this.refreshView();
        }
        return elementChanges;
    }

    protected boolean processLabelBinding(ElementChanges elementChanges, boolean refreshView) {
        String newLabelValue;
        BindingResult labelBidingResult;
        BindingResult bindingResult = labelBidingResult = this.labelModelBinding != null ? this.labelModelBinding.getBindingResult() : null;
        if (labelBidingResult != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(labelBidingResult), this.label)) {
            this.label = newLabelValue;
            elementChanges.addChange(ATTR_LABEL, (Object)this.label);
            refreshView = true;
        }
        return refreshView;
    }

    public String getType() {
        return TYPE_NAME;
    }

    public void onDesignerAddDefaultSubcomponent(SpacerService spacerService) {
        this.addSubcomponent((Component)this.createNewRow());
    }

    public Row createNewRow() {
        Row row = new Row(this.getForm());
        row.setGroupingParentComponent((IGroupingComponent)this);
        row.init();
        return row;
    }

    public String getLabel() {
        return this.label;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    @JsonIgnore
    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public boolean isLayoutGenerated() {
        return this.layoutGenerated;
    }
}

