/*
 * Decompiled with CFR 0.152.
 */
package software.nectar.java.factory;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import software.nectar.java.factory.base.BaseFactory;
import software.nectar.java.factory.base.exceptions.ApiResponseException;
import software.nectar.java.models.Credits;

public class CreditsFactory
extends BaseFactory<Credits> {
    private final String CREDITS_PATH = "/v1/credits";
    private final String TRANSACTIONS_PATH = "/v1/transactions";

    public CreditsFactory(String key, String secret) {
        super(key, secret);
    }

    public Credits getCredits() throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        return this.extractFrom(this.get("/v1/credits", "", "application/json"));
    }

    public Credits getTransactions() throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        return this.extractFrom(this.get("/v1/transactions", "", "application/json"));
    }

    @Override
    public List<Credits> extractMultipleFrom(JSONObject responseObj) throws ApiResponseException {
        return null;
    }

    @Override
    public Credits extractFrom(JSONObject responseObj) throws ApiResponseException {
        if (responseObj.getJSONObject("status").getInt("code") == 200) {
            JSONObject credits = responseObj.getJSONObject("data").getJSONObject("data");
            return new Credits(((BigDecimal)credits.get("credits")).doubleValue(), this.extractPurchases(credits), this.extractConsumption(credits));
        }
        throw new ApiResponseException(responseObj.getJSONObject("status").getString("message"));
    }

    private List<Credits.Purchase> extractPurchases(JSONObject credits) {
        ArrayList<Credits.Purchase> extractedPurchases = new ArrayList<Credits.Purchase>();
        if (credits.has("purchases")) {
            JSONArray purchases = (JSONArray)credits.get("purchases");
            for (Object purchase : purchases) {
                extractedPurchases.add(new Credits.Purchase((String)((JSONObject)purchase).get("ref"), (String)((JSONObject)purchase).get("user_ref"), ((BigDecimal)((JSONObject)purchase).get("value")).doubleValue(), ((BigDecimal)((JSONObject)purchase).get("units")).doubleValue(), (String)((JSONObject)purchase).get("currency"), Instant.parse((String)((JSONObject)purchase).get("purchase_date"))));
            }
        }
        return extractedPurchases;
    }

    private List<Credits.Consumption> extractConsumption(JSONObject credits) {
        ArrayList<Credits.Consumption> extractedConsumptions = new ArrayList<Credits.Consumption>();
        if (credits.has("consumptions")) {
            JSONArray consumptions = (JSONArray)credits.get("consumptions");
            consumptions.forEach(consumption -> extractedConsumptions.add(new Credits.Consumption((String)((JSONObject)consumption).get("ref"), ((BigDecimal)((JSONObject)consumption).get("units")).doubleValue(), Instant.parse((String)((JSONObject)consumption).get("consumption_date")), (String)((JSONObject)consumption).get("user_ref"), (String)((JSONObject)consumption).get("token_ref"))));
        }
        return extractedConsumptions;
    }
}

