/*
 * Decompiled with CFR 0.152.
 */
package software.nectar.java.factory.base;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;
import software.nectar.java.factory.base.exceptions.ApiResponseException;
import software.nectar.java.utils.Authentication;
import software.nectar.java.utils.MD5;
import software.nectar.java.utils.Nonce;
import software.nectar.java.utils.Payload;

public abstract class BaseFactory<T> {
    protected final String JSON_CONTENT_TYPE = "application/json";
    protected final String BASE_PATH = "https://api.nectar.software";
    protected String key;
    protected String secret;

    public BaseFactory(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    protected Payload createPayload(HashMap<String, Object> params) {
        return new Payload(params);
    }

    protected String md5(String str) throws NoSuchAlgorithmException {
        return new MD5().md5(str);
    }

    protected String generateNonce() {
        return new Nonce().generateNonce();
    }

    protected String generateHMACAuth(String secret, Http verb, String urlPath, String md5, String contentType, Date date, String nonce) throws InvalidKeyException, NoSuchAlgorithmException {
        return new Authentication().generateHMAC(secret, verb.name(), urlPath, md5, contentType, date.toString(), nonce);
    }

    protected JSONObject post(String path, Payload payload, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        String md5 = this.md5(payload.toJson().toString());
        String nonce = this.generateNonce();
        Date currDate = new Date();
        String hmac = this.generateHMACAuth(this.secret, Http.POST, path, md5, contentType, currDate, nonce);
        return this.initiateRequest(Http.POST, contentType, md5, path, hmac, nonce, payload.toJson().toString(), currDate);
    }

    protected JSONObject get(String path, String pathArgs, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        String md5 = this.md5("");
        Date currDate = new Date();
        String nonce = this.generateNonce();
        String hmac = this.generateHMACAuth(this.secret, Http.GET, path, md5, contentType, currDate, nonce);
        return this.initiateRequest(Http.GET, contentType, md5, String.format("%s?%s", path, pathArgs), hmac, nonce, null, currDate);
    }

    protected JSONObject gets(String path, String pathArgs, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        String md5 = this.md5("");
        Date currDate = new Date();
        String nonce = this.generateNonce();
        String hmac = this.generateHMACAuth(this.secret, Http.GET, path, md5, contentType, currDate, nonce);
        return this.initiateMultipleResponseRequest(Http.GET, contentType, md5, String.format("%s?%s", path, pathArgs), hmac, nonce, null, currDate);
    }

    protected JSONObject delete(String path, String pathArgs, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        String md5 = this.md5("");
        Date currDate = new Date();
        String nonce = this.generateNonce();
        String hmac = this.generateHMACAuth(this.secret, Http.DELETE, path, md5, contentType, currDate, nonce);
        return this.initiateRequest(Http.DELETE, contentType, md5, String.format("%s?%s", path, pathArgs), hmac, nonce, null, currDate);
    }

    protected JSONObject put(String path, String pathArgs, Payload payload, String contentType) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ApiResponseException {
        String payloadStr = null != payload ? payload.toJson().toString() : "";
        String md5 = this.md5(payloadStr);
        String nonce = this.generateNonce();
        Date currDate = new Date();
        String hmac = this.generateHMACAuth(this.secret, Http.PUT, path, md5, contentType, currDate, nonce);
        return this.initiateRequest(Http.PUT, contentType, md5, String.format("%s?%s", path, pathArgs), hmac, nonce, payloadStr, currDate);
    }

    protected JSONObject initiateMultipleResponseRequest(Http method, String contentType, String md5, String endpoint, String hmac, String nonce, String payload, Date date) throws IOException, ApiResponseException {
        return this.makeRequest(method, contentType, md5, endpoint, hmac, nonce, payload, date);
    }

    protected JSONObject initiateRequest(Http method, String contentType, String md5, String endpoint, String hmac, String nonce, String payload, Date date) throws IOException, ApiResponseException {
        return this.makeRequest(method, contentType, md5, endpoint, hmac, nonce, payload, date);
    }

    public abstract T extractFrom(JSONObject var1) throws ApiResponseException;

    public abstract List<T> extractMultipleFrom(JSONObject var1) throws ApiResponseException;

    private JSONObject makeRequest(Http method, String contentType, String md5, String endpoint, String hmac, String nonce, String payload, Date date) throws IOException {
        String inputLine;
        URL url = new URL(String.format("%s%s", "https://api.nectar.software", endpoint));
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod(method.name());
        http.setDoOutput(true);
        http.setRequestProperty("Authorization", String.format("nectar %s:%s", this.key, hmac));
        http.setRequestProperty("Content-Type", contentType);
        http.setRequestProperty("Content-MD5", md5);
        http.setRequestProperty("Date", date.toString());
        http.setRequestProperty("nonce", nonce);
        http.setRequestProperty("User-Agent", "nectar-java-sdk");
        if (null != payload) {
            http.setFixedLengthStreamingMode(payload.length());
            DataOutputStream wr = new DataOutputStream(http.getOutputStream());
            wr.writeBytes(payload);
            wr.flush();
            wr.close();
        }
        int responseCode = http.getResponseCode();
        System.out.println("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream(), "UTF-8"));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return new JSONObject(response.toString());
    }

    protected static enum Http {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

