/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.api.items.providers;

import com.nexomc.nexo.api.NexoItems;
import java.util.Objects;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.PrefixHelper;
import studio.magemonkey.codex.api.items.providers.ICodexItemProvider;

public class NexoProvider
implements ICodexItemProvider<NexoItemType>,
Listener {
    public static final String NAMESPACE = "NEXO";

    @Override
    public String pluginName() {
        return "Nexo";
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public ICodexItemProvider.Category getCategory() {
        return ICodexItemProvider.Category.EXTERNAL;
    }

    @Override
    @Nullable
    public NexoItemType getItem(String id) {
        if (id == null || id.isBlank()) {
            return null;
        }
        id = PrefixHelper.stripPrefix(NAMESPACE, id);
        return new NexoItemType(id);
    }

    @Override
    @Nullable
    public NexoItemType getItem(ItemStack itemStack) {
        return this.getItem(NexoItems.idFromItem((ItemStack)itemStack));
    }

    @Override
    public boolean isCustomItem(ItemStack item) {
        return NexoItems.idFromItem((ItemStack)item) != null;
    }

    @Override
    public boolean isCustomItemOfId(ItemStack item, String id) {
        if (!NexoItems.exists((String)(id = PrefixHelper.stripPrefix(NAMESPACE, id)))) {
            return false;
        }
        String itemId = NexoItems.idFromItem((ItemStack)item);
        return itemId != null && itemId.equals(id);
    }

    public static class NexoItemType
    extends ItemType {
        private final String id;

        public NexoItemType(String id) {
            this.id = id;
        }

        @Override
        public String getNamespace() {
            return NexoProvider.NAMESPACE;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public ICodexItemProvider.Category getCategory() {
            return ICodexItemProvider.Category.EXTERNAL;
        }

        @Override
        public ItemStack create() {
            if (!NexoItems.exists((String)this.id)) {
                Codex.warn("Could not find NEXO item with ID " + this.id + ". Has Nexo fully initialized?");
                return null;
            }
            return Objects.requireNonNull(NexoItems.itemFromId((String)this.id)).build();
        }

        @Override
        public boolean isInstance(@Nullable ItemStack itemStack) {
            String itemId = NexoItems.idFromItem((ItemStack)itemStack);
            return itemId != null && itemId.equals(this.id);
        }
    }
}

