/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.manager.api.menu;

import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.manager.IManager;
import studio.magemonkey.codex.manager.api.menu.Menu;
import studio.magemonkey.codex.manager.api.menu.Slot;

public class MenuManager
extends IManager<JavaPlugin> {
    public MenuManager(JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void setup() {
        this.registerListeners();
    }

    @Override
    public void shutdown() {
        this.unregisterListeners();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory otherInventory;
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        Inventory top = VersionManager.getCompat().getTopInventory((InventoryEvent)event);
        Inventory bottom = VersionManager.getCompat().getBottomInventory((InventoryEvent)event);
        Inventory inventory2 = otherInventory = top == inventory ? bottom : top;
        if (otherInventory.getHolder() instanceof Menu && event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            event.setCancelled(true);
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder instanceof Menu) {
            event.setCancelled(true);
            Slot slot = ((Menu)holder).getSlot(event.getSlot());
            if (slot != null) {
                switch (event.getClick()) {
                    case LEFT: {
                        slot.onLeftClick();
                        break;
                    }
                    case SHIFT_LEFT: {
                        slot.onShiftLeftClick();
                        break;
                    }
                    case RIGHT: {
                        slot.onRightClick();
                        break;
                    }
                    case SHIFT_RIGHT: {
                        slot.onShiftRightClick();
                        break;
                    }
                    case MIDDLE: {
                        slot.onMiddleClick();
                        break;
                    }
                    case NUMBER_KEY: {
                        slot.onNumberClick(event.getHotbarButton());
                        break;
                    }
                    case DOUBLE_CLICK: {
                        slot.onDoubleClick();
                        break;
                    }
                    case DROP: {
                        slot.onDrop();
                        break;
                    }
                    case CONTROL_DROP: {
                        slot.onControlDrop();
                        break;
                    }
                    case SWAP_OFFHAND: {
                        slot.onSwapOffhand();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        for (Integer rawSlot : event.getRawSlots()) {
            Inventory inventory = VersionManager.getCompat().getInventory((InventoryEvent)event, rawSlot);
            if (inventory == null || !(inventory.getHolder() instanceof Menu)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Menu menu;
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Menu && !(menu = (Menu)holder).isOpening()) {
            new BukkitRunnable(){

                public void run() {
                    menu.onClose();
                }
            }.runTask((Plugin)this.plugin);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Menu openMenu = Menu.getOpenMenu(event.getPlayer());
        if (openMenu != null) {
            openMenu.onClose();
        }
    }
}

