/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;

public class NumberUT {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.##");

    @NotNull
    public static String format(double d) {
        return NUMBER_FORMAT.format(d).replace(",", ".");
    }

    @NotNull
    public static String format(double d, @NotNull String pattern) {
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(d).replace(",", ".");
    }

    public static double round(double d) {
        return Double.valueOf(NumberUT.format(d));
    }

    public static double round(double d, @NotNull String pattern) {
        return Double.valueOf(NumberUT.format(d, pattern));
    }

    @NotNull
    public static String toRoman(int input) {
        if (input < 1 || input > 3999) {
            return "N/A";
        }
        Object s = "";
        while (input >= 1000) {
            s = (String)s + "M";
            input -= 1000;
        }
        while (input >= 900) {
            s = (String)s + "CM";
            input -= 900;
        }
        while (input >= 500) {
            s = (String)s + "D";
            input -= 500;
        }
        while (input >= 400) {
            s = (String)s + "CD";
            input -= 400;
        }
        while (input >= 100) {
            s = (String)s + "C";
            input -= 100;
        }
        while (input >= 90) {
            s = (String)s + "XC";
            input -= 90;
        }
        while (input >= 50) {
            s = (String)s + "L";
            input -= 50;
        }
        while (input >= 40) {
            s = (String)s + "XL";
            input -= 40;
        }
        while (input >= 10) {
            s = (String)s + "X";
            input -= 10;
        }
        while (input >= 9) {
            s = (String)s + "IX";
            input -= 9;
        }
        while (input >= 5) {
            s = (String)s + "V";
            input -= 5;
        }
        while (input >= 4) {
            s = (String)s + "IV";
            input -= 4;
        }
        while (input >= 1) {
            s = (String)s + "I";
            --input;
        }
        return s;
    }

    public static int fromRoman(@NotNull String romanNumber) {
        int decimal = 0;
        int lastNumber = 0;
        String romanNumeral = romanNumber.toUpperCase();
        block9: for (int x = romanNumeral.length() - 1; x >= 0; --x) {
            char convertToDecimal = romanNumeral.charAt(x);
            switch (convertToDecimal) {
                case 'M': {
                    decimal = NumberUT.processDecimal(1000, lastNumber, decimal);
                    lastNumber = 1000;
                    continue block9;
                }
                case 'D': {
                    decimal = NumberUT.processDecimal(500, lastNumber, decimal);
                    lastNumber = 500;
                    continue block9;
                }
                case 'C': {
                    decimal = NumberUT.processDecimal(100, lastNumber, decimal);
                    lastNumber = 100;
                    continue block9;
                }
                case 'L': {
                    decimal = NumberUT.processDecimal(50, lastNumber, decimal);
                    lastNumber = 50;
                    continue block9;
                }
                case 'X': {
                    decimal = NumberUT.processDecimal(10, lastNumber, decimal);
                    lastNumber = 10;
                    continue block9;
                }
                case 'V': {
                    decimal = NumberUT.processDecimal(5, lastNumber, decimal);
                    lastNumber = 5;
                    continue block9;
                }
                case 'I': {
                    decimal = NumberUT.processDecimal(1, lastNumber, decimal);
                    lastNumber = 1;
                }
            }
        }
        return decimal;
    }

    private static int processDecimal(int decimal, int lastNumber, int lastDecimal) {
        if (lastNumber > decimal) {
            return lastDecimal - decimal;
        }
        return lastDecimal + decimal;
    }

    public static int[] splitIntoParts(int whole, int parts) {
        int[] arr = new int[parts];
        int remain = whole;
        int partsLeft = parts;
        int i = 0;
        while (partsLeft > 0) {
            int size;
            arr[i] = size = (remain + partsLeft - 1) / partsLeft;
            remain -= size;
            --partsLeft;
            ++i;
        }
        return arr;
    }
}

