/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.codex.util.random;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.random.MTRandom;

public class Rnd {
    public static final MTRandom rnd = new MTRandom();
    private static final List<String> MATERIAL_COLORS = Arrays.asList("WHITE", "BLACK", "ORANGE", "YELLOW", "RED", "GREEN", "LIME", "BLUE", "CYAN", "BROWN", "GRAY", "PURPLE", "PINK", "MAGENTA", "LIGHT_GRAY", "LIGHT_BLUE");

    public static float get() {
        return rnd.nextFloat();
    }

    public static float get(boolean normalize) {
        float f = Rnd.get();
        if (normalize) {
            f *= 100.0f;
        }
        return f;
    }

    public static int get(int n) {
        return Rnd.nextInt(n);
    }

    public static int get(int min, int max) {
        return min + (int)Math.floor(rnd.nextDouble() * (double)(max - min + 1));
    }

    public static double getDouble(double max) {
        return Rnd.getDouble(0.0, max);
    }

    public static double getDouble(double min, double max) {
        return min + (max - min) * rnd.nextDouble();
    }

    public static double getDoubleNega(double min, double max) {
        double range = max - min;
        double scaled = rnd.nextDouble() * range;
        double shifted = scaled + min;
        return shifted;
    }

    @NotNull
    public static <E> E get(@NotNull E[] list) {
        return list[Rnd.get(list.length)];
    }

    public static int get(int[] list) {
        return list[Rnd.get(list.length)];
    }

    @Nullable
    public static <E> E get(@NotNull List<E> list) {
        return list.isEmpty() ? null : (E)list.get(Rnd.get(list.size()));
    }

    @Nullable
    public static <T> T get(@NotNull Map<T, Double> map) {
        List<T> list = Rnd.get(map, 1);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @NotNull
    public static <T> List<T> get(@NotNull Map<T, Double> map, int amount) {
        map.values().removeIf(chance -> chance <= 0.0);
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        double total = map.values().stream().mapToDouble(d -> d).sum();
        block0: for (int count = 0; count < amount; ++count) {
            double index = Rnd.getDouble(0.0, total);
            double countWeight = 0.0;
            for (Map.Entry<T, Double> en : map.entrySet()) {
                if (!((countWeight += en.getValue().doubleValue()) >= index)) continue;
                list.add(en.getKey());
                continue block0;
            }
        }
        return list;
    }

    @Deprecated
    @Nullable
    public static <T> T getRandomItem(@NotNull Map<T, Double> map) {
        return Rnd.getRandomItem(map, true);
    }

    @Deprecated
    @Nullable
    public static <T> T getRandomItem(@NotNull Map<T, Double> map, boolean alwaysHundred) {
        return Rnd.get(map);
    }

    public static boolean chance(int chance) {
        return chance >= 1 && (chance > 99 || Rnd.nextInt(99) + 1 <= chance);
    }

    public static boolean chance(double chance) {
        return Rnd.nextDouble() <= chance / 100.0;
    }

    public static int nextInt(int n) {
        return (int)Math.floor(rnd.nextDouble() * (double)n);
    }

    public static int nextInt() {
        return rnd.nextInt();
    }

    public static double nextDouble() {
        return rnd.nextDouble();
    }

    public static double nextGaussian() {
        return rnd.nextGaussian();
    }

    public static boolean nextBoolean() {
        return rnd.nextBoolean();
    }

    @NotNull
    public static Firework spawnRandomFirework(@NotNull Location loc) {
        World w = loc.getWorld();
        if (w == null) {
            w = (World)Bukkit.getWorlds().get(0);
        }
        Firework fw = (Firework)w.spawnEntity(loc, EntityType.fromName((String)"firework_rocket"));
        FireworkMeta meta = fw.getFireworkMeta();
        FireworkEffect.Type type = Rnd.get(FireworkEffect.Type.values());
        Color c1 = Color.fromBGR((int)Rnd.nextInt(254), (int)Rnd.nextInt(254), (int)Rnd.nextInt(254));
        Color c2 = Color.fromBGR((int)Rnd.nextInt(254), (int)Rnd.nextInt(254), (int)Rnd.nextInt(254));
        FireworkEffect effect = FireworkEffect.builder().flicker(Rnd.nextBoolean()).withColor(c1).withFade(c2).with(type).trail(Rnd.nextBoolean()).build();
        meta.addEffect(effect);
        int power = Rnd.get(5);
        meta.setPower(power);
        fw.setFireworkMeta(meta);
        return fw;
    }

    @NotNull
    public static Material getColoredMaterial(@NotNull Material m) {
        Material get;
        String name = m.name();
        for (String c : MATERIAL_COLORS) {
            if (!name.startsWith(c)) continue;
            String color = Rnd.get(MATERIAL_COLORS);
            name = name.replace(c, color);
            break;
        }
        if ((get = Material.getMaterial((String)name)) == null) {
            return Material.BARRIER;
        }
        return get;
    }
}

