/*
 * Decompiled with CFR 0.152.
 */
package com.intigua.antlr4.autosuggest;

import com.intigua.antlr4.autosuggest.CasePreference;
import com.intigua.antlr4.autosuggest.LexerWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenSuggester {
    private static final Logger logger = LoggerFactory.getLogger(TokenSuggester.class);
    private final LexerWrapper lexerWrapper;
    private final CasePreference casePreference;
    private final Set<String> suggestions = new TreeSet<String>();
    private final List<Integer> visitedLexerStates = new ArrayList<Integer>();
    private String origPartialToken;

    public TokenSuggester(LexerWrapper lexerWrapper, String input) {
        this(input, lexerWrapper, CasePreference.BOTH);
    }

    public TokenSuggester(String origPartialToken, LexerWrapper lexerWrapper, CasePreference casePreference) {
        this.origPartialToken = origPartialToken;
        this.lexerWrapper = lexerWrapper;
        this.casePreference = casePreference;
    }

    public Collection<String> suggest(Collection<Integer> nextParserTransitionLabels) {
        this.logTokensUsedForSuggestion(nextParserTransitionLabels);
        for (int nextParserTransitionLabel : nextParserTransitionLabels) {
            int nextTokenRuleNumber = nextParserTransitionLabel - 1;
            ATNState lexerState = this.lexerWrapper.findStateByRuleNumber(nextTokenRuleNumber);
            this.suggest("", lexerState, this.origPartialToken);
        }
        return this.suggestions;
    }

    private void logTokensUsedForSuggestion(Collection<Integer> ruleIndices) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        String ruleNames = ruleIndices.stream().map(r -> this.lexerWrapper.getRuleNames()[r - 1]).collect(Collectors.joining(" "));
        logger.debug("Suggesting tokens for lexer rules: " + ruleNames, (Object)" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suggest(String tokenSoFar, ATNState lexerState, String remainingText) {
        logger.debug("SUGGEST: tokenSoFar=" + tokenSoFar + " remainingText=" + remainingText + " lexerState=" + this.toString(lexerState));
        if (this.visitedLexerStates.contains(lexerState.stateNumber)) {
            return;
        }
        this.visitedLexerStates.add(lexerState.stateNumber);
        try {
            boolean noMoreCharactersInToken;
            Transition[] transitions = lexerState.getTransitions();
            boolean tokenNotEmpty = tokenSoFar.length() > 0;
            boolean bl = noMoreCharactersInToken = transitions.length == 0;
            if (tokenNotEmpty && noMoreCharactersInToken) {
                this.addSuggestedToken(tokenSoFar);
                return;
            }
            for (Transition trans : transitions) {
                this.suggestViaLexerTransition(tokenSoFar, remainingText, trans);
            }
        }
        finally {
            this.visitedLexerStates.remove(this.visitedLexerStates.size() - 1);
        }
    }

    private String toString(ATNState lexerState) {
        String ruleName = this.lexerWrapper.getRuleNames()[lexerState.ruleIndex];
        return ruleName + " " + lexerState.getClass().getSimpleName() + " " + lexerState;
    }

    private void suggestViaLexerTransition(String tokenSoFar, String remainingText, Transition trans) {
        if (trans.isEpsilon()) {
            this.suggest(tokenSoFar, trans.target, remainingText);
        } else if (trans instanceof AtomTransition) {
            String newTokenChar = this.getAddedTextFor((AtomTransition)trans);
            if (remainingText.isEmpty() || remainingText.startsWith(newTokenChar)) {
                logger.debug("LEXER TOKEN: " + newTokenChar + " remaining=" + remainingText);
                this.suggestViaNonEpsilonLexerTransition(tokenSoFar, remainingText, newTokenChar, trans.target);
            } else {
                logger.debug("NONMATCHING LEXER TOKEN: " + newTokenChar + " remaining=" + remainingText);
            }
        } else if (trans instanceof SetTransition) {
            List symbols = ((SetTransition)trans).label().toList();
            for (Integer symbol : symbols) {
                char[] charArr = Character.toChars(symbol);
                String charStr = new String(charArr);
                boolean shouldIgnoreCase = this.shouldIgnoreThisCase(charArr[0], symbols);
                if (shouldIgnoreCase || !remainingText.isEmpty() && !remainingText.startsWith(charStr)) continue;
                this.suggestViaNonEpsilonLexerTransition(tokenSoFar, remainingText, charStr, trans.target);
            }
        }
    }

    private void suggestViaNonEpsilonLexerTransition(String tokenSoFar, String remainingText, String newTokenChar, ATNState targetState) {
        String newRemainingText = remainingText.length() > 0 ? remainingText.substring(1) : remainingText;
        this.suggest(tokenSoFar + newTokenChar, targetState, newRemainingText);
    }

    private void addSuggestedToken(String tokenToAdd) {
        String justTheCompletionPart = this.chopOffCommonStart(tokenToAdd, this.origPartialToken);
        this.suggestions.add(justTheCompletionPart);
    }

    private String chopOffCommonStart(String a, String b) {
        int charsToChopOff = Math.min(b.length(), a.length());
        return a.substring(charsToChopOff);
    }

    private String getAddedTextFor(AtomTransition transition) {
        return new String(Character.toChars(transition.label));
    }

    private boolean shouldIgnoreThisCase(char transChar, List<Integer> allTransChars) {
        if (this.casePreference == null) {
            return false;
        }
        switch (this.casePreference) {
            case BOTH: {
                return false;
            }
            case LOWER: {
                return Character.isUpperCase(transChar) && allTransChars.contains(Character.toLowerCase(transChar));
            }
            case UPPER: {
                return Character.isLowerCase(transChar) && allTransChars.contains(Character.toUpperCase(transChar));
            }
        }
        return false;
    }
}

