/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import ai.tecton.client.exceptions.TectonClientException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class GetFeaturesRequestData {
    private Map<String, String> joinKeyMap = new HashMap<String, String>();
    private Map<String, Object> requestContextMap = new HashMap<String, Object>();

    public GetFeaturesRequestData addJoinKeyMap(Map<String, String> joinKeyMap) throws TectonClientException {
        Validate.notEmpty(joinKeyMap);
        joinKeyMap.forEach(this::validateKeyValue);
        this.joinKeyMap = joinKeyMap;
        return this;
    }

    public GetFeaturesRequestData addRequestContextMap(Map<String, Object> requestContextMap) throws TectonClientException {
        Validate.notEmpty(requestContextMap);
        requestContextMap.forEach(this::validateKeyValue);
        this.requestContextMap = requestContextMap;
        return this;
    }

    public GetFeaturesRequestData addJoinKey(String key, String value) throws TectonClientException {
        this.validateKeyValue(key, value);
        this.joinKeyMap.put(key, value);
        return this;
    }

    public GetFeaturesRequestData addJoinKey(String key, Long value) throws TectonClientException {
        this.validateKeyValue(key, value.toString());
        this.joinKeyMap.put(key, value.toString());
        return this;
    }

    public GetFeaturesRequestData addRequestContext(String key, String value) throws TectonClientException {
        this.validateKeyValue(key, value);
        this.requestContextMap.put(key, value);
        return this;
    }

    public GetFeaturesRequestData addRequestContext(String key, Long value) throws TectonClientException {
        this.validateKeyValue(key, value);
        this.requestContextMap.put(key, value.toString());
        return this;
    }

    public GetFeaturesRequestData addRequestContext(String key, Double value) throws TectonClientException {
        this.validateKeyValue(key, value);
        this.requestContextMap.put(key, value);
        return this;
    }

    Map<String, String> getJoinKeyMap() {
        return this.joinKeyMap;
    }

    Map<String, Object> getRequestContextMap() {
        return this.requestContextMap;
    }

    boolean isEmptyJoinKeyMap() {
        return this.joinKeyMap.isEmpty();
    }

    boolean isEmptyRequestContextMap() {
        return this.requestContextMap.isEmpty();
    }

    private void validateKeyValue(String key, Object value) {
        Validate.notEmpty(key, "Key/Value cannot be null or empty", new Object[0]);
        Validate.notNull(value, "Key/Value cannot be null or empty", new Object[0]);
        if (value instanceof String) {
            Validate.notEmpty((String)value, "Key/Value cannot be null or empty", new Object[0]);
        }
    }
}

