/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.transport.TectonHttpClient;
import org.apache.commons.lang3.Validate;

public abstract class AbstractTectonRequest {
    private final String endpoint;
    private final TectonHttpClient.HttpMethod method;
    private final String workspaceName;
    private final String featureServiceName;

    public AbstractTectonRequest(String endpoint, TectonHttpClient.HttpMethod method, String workspaceName, String featureServiceName) throws TectonClientException {
        AbstractTectonRequest.validateRequestParameters(workspaceName, featureServiceName);
        this.endpoint = endpoint;
        this.method = method;
        this.workspaceName = workspaceName;
        this.featureServiceName = featureServiceName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TectonHttpClient.HttpMethod getMethod() {
        return this.method;
    }

    public String getFeatureServiceName() {
        return this.featureServiceName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public abstract String requestToJson();

    static void validateRequestParameters(String workspaceName, String featureServiceName) {
        try {
            Validate.notEmpty((CharSequence)workspaceName, (String)"Workspace Name cannot be null or empty", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)featureServiceName, (String)"FeatureService Name cannot be null or empty", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new TectonClientException(e.getMessage());
        }
    }
}

