/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.MetadataOption;
import ai.tecton.client.request.AbstractGetFeaturesRequest;
import ai.tecton.client.request.AbstractTectonRequest;
import ai.tecton.client.request.GetFeaturesRequest;
import ai.tecton.client.request.GetFeaturesRequestData;
import ai.tecton.client.request.RequestConstants;
import ai.tecton.client.transport.TectonHttpClient;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class GetFeaturesBatchRequest {
    private List<? extends AbstractGetFeaturesRequest> requestList;
    private final int microBatchSize;
    private final Duration timeout;
    private static final String BATCH_ENDPOINT = "/api/v1/feature-service/get-features-batch";
    private static JsonAdapter<GetFeaturesMicroBatchRequest.GetFeaturesRequestBatchJson> jsonAdapter = null;
    private String endpoint;
    private TectonHttpClient.HttpMethod method;

    public GetFeaturesBatchRequest(String workspaceName, String featureServiceName, List<GetFeaturesRequestData> requestDataList) {
        this(workspaceName, featureServiceName, requestDataList, RequestConstants.DEFAULT_METADATA_OPTIONS, 1, RequestConstants.NONE_TIMEOUT);
    }

    public GetFeaturesBatchRequest(String workspaceName, String featureServiceName, List<GetFeaturesRequestData> requestDataList, Set<MetadataOption> metadataOptions) {
        this(workspaceName, featureServiceName, requestDataList, metadataOptions, 1, RequestConstants.NONE_TIMEOUT);
    }

    public GetFeaturesBatchRequest(String workspaceName, String featureServiceName, List<GetFeaturesRequestData> requestDataList, Set<MetadataOption> metadataOptions, int microBatchSize) {
        this(workspaceName, featureServiceName, requestDataList, metadataOptions, microBatchSize, RequestConstants.NONE_TIMEOUT);
    }

    public GetFeaturesBatchRequest(String workspaceName, String featureServiceName, List<GetFeaturesRequestData> requestDataList, Set<MetadataOption> metadataOptions, int microBatchSize, Duration timeout) {
        GetFeaturesBatchRequest.validateParameters(workspaceName, featureServiceName, requestDataList, microBatchSize);
        this.timeout = timeout;
        if (microBatchSize > 1 && requestDataList.size() > 1) {
            this.requestList = ListUtils.partition(requestDataList, (int)microBatchSize).parallelStream().map(requestData -> new GetFeaturesMicroBatchRequest(workspaceName, featureServiceName, (List<GetFeaturesRequestData>)requestData, metadataOptions)).collect(Collectors.toList());
            this.microBatchSize = microBatchSize;
            Moshi moshi = new Moshi.Builder().build();
            jsonAdapter = moshi.adapter(GetFeaturesMicroBatchRequest.GetFeaturesRequestBatchJson.class);
            this.endpoint = BATCH_ENDPOINT;
            this.method = TectonHttpClient.HttpMethod.POST;
        } else {
            this.requestList = requestDataList.parallelStream().map(requestData -> new GetFeaturesRequest(workspaceName, featureServiceName, (GetFeaturesRequestData)requestData, metadataOptions)).collect(Collectors.toList());
            this.microBatchSize = microBatchSize;
            this.endpoint = "/api/v1/feature-service/get-features";
            this.method = TectonHttpClient.HttpMethod.POST;
        }
    }

    public List<? extends AbstractGetFeaturesRequest> getRequestList() {
        return this.requestList;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getMicroBatchSize() {
        return this.microBatchSize;
    }

    public TectonHttpClient.HttpMethod getMethod() {
        return this.method;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    private static void validateParameters(String workspaceName, String featureServiceName, List<GetFeaturesRequestData> requestDataList, int microBatchSize) {
        AbstractTectonRequest.validateRequestParameters(workspaceName, featureServiceName);
        if (requestDataList == null || requestDataList.isEmpty()) {
            throw new TectonClientException("The list of GetFeaturesRequestData objects cannot be null or empty");
        }
        requestDataList.parallelStream().forEach(AbstractGetFeaturesRequest::validateRequestParameters);
        if (microBatchSize > 5 || microBatchSize < 1) {
            throw new TectonClientException(String.format("The microBatchSize is out of bounds and should be in the range [ %s , %s ]", 1, 5));
        }
    }

    static class GetFeaturesMicroBatchRequest
    extends AbstractGetFeaturesRequest {
        private final List<GetFeaturesRequestData> requestDataList;

        GetFeaturesMicroBatchRequest(String workspaceName, String featureServiceName, List<GetFeaturesRequestData> requestDataList, Set<MetadataOption> metadataOptions) {
            super(workspaceName, featureServiceName, GetFeaturesBatchRequest.BATCH_ENDPOINT, metadataOptions);
            this.requestDataList = requestDataList;
        }

        List<GetFeaturesRequestData> getFeaturesRequestData() {
            return this.requestDataList;
        }

        @Override
        public String requestToJson() {
            GetFeaturesBatchFields getFeaturesFields = new GetFeaturesBatchFields();
            getFeaturesFields.feature_service_name = this.getFeatureServiceName();
            getFeaturesFields.workspace_name = this.getWorkspaceName();
            getFeaturesFields.request_data = new ArrayList<RequestDataField>(this.requestDataList.size());
            this.requestDataList.forEach(requestData -> {
                RequestDataField requestDataField = new RequestDataField();
                if (!requestData.isEmptyJoinKeyMap()) {
                    requestDataField.join_key_map = requestData.getJoinKeyMap();
                }
                if (!requestData.isEmptyRequestContextMap()) {
                    requestDataField.request_context_map = requestData.getRequestContextMap();
                }
                getFeaturesFields.request_data.add(requestDataField);
            });
            if (!this.metadataOptions.isEmpty()) {
                getFeaturesFields.metadata_options = this.metadataOptions.stream().collect(Collectors.toMap(MetadataOption::getJsonName, a -> Boolean.TRUE));
            }
            GetFeaturesRequestBatchJson getFeaturesRequestJson = new GetFeaturesRequestBatchJson(getFeaturesFields);
            try {
                return jsonAdapter.toJson((Object)getFeaturesRequestJson);
            }
            catch (Exception e) {
                throw new TectonClientException(String.format("The parameters passed to the GetFeaturesBatchRequest are invalid. %s", e.getMessage()));
            }
        }

        static class RequestDataField {
            Map<String, String> join_key_map;
            Map<String, Object> request_context_map;

            RequestDataField() {
            }
        }

        static class GetFeaturesBatchFields {
            String feature_service_name;
            String workspace_name;
            List<RequestDataField> request_data;
            Map<String, Boolean> metadata_options;

            GetFeaturesBatchFields() {
            }
        }

        static class GetFeaturesRequestBatchJson {
            GetFeaturesBatchFields params;

            GetFeaturesRequestBatchJson(GetFeaturesBatchFields params) {
                this.params = params;
            }
        }
    }

    public static class Builder {
        private String workspaceName;
        private String featureServiceName;
        private List<GetFeaturesRequestData> requestDataList;
        private Set<MetadataOption> metadataOptionList = RequestConstants.DEFAULT_METADATA_OPTIONS;
        private int microBatchSize = 1;
        private Duration timeout = RequestConstants.NONE_TIMEOUT;

        public Builder() {
            this.requestDataList = new ArrayList<GetFeaturesRequestData>();
        }

        public Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public Builder featureServiceName(String featureServiceName) {
            this.featureServiceName = featureServiceName;
            return this;
        }

        public Builder requestDataList(List<GetFeaturesRequestData> requestDataList) throws TectonClientException {
            this.requestDataList = requestDataList;
            return this;
        }

        public Builder addRequestData(GetFeaturesRequestData requestData) {
            this.requestDataList.add(requestData);
            return this;
        }

        public Builder metadataOptions(Set<MetadataOption> metadataOptions) {
            this.metadataOptionList = metadataOptions;
            return this;
        }

        public Builder microBatchSize(int microBatchSize) throws TectonClientException {
            this.microBatchSize = microBatchSize;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public GetFeaturesBatchRequest build() throws TectonClientException {
            return new GetFeaturesBatchRequest(this.workspaceName, this.featureServiceName, this.requestDataList, this.metadataOptionList, this.microBatchSize, this.timeout);
        }
    }
}

