/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client;

import ai.tecton.client.TectonClientOptions;
import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.exceptions.TectonServiceException;
import ai.tecton.client.request.AbstractTectonRequest;
import ai.tecton.client.request.GetFeatureServiceMetadataRequest;
import ai.tecton.client.request.GetFeaturesBatchRequest;
import ai.tecton.client.request.GetFeaturesRequest;
import ai.tecton.client.response.GetFeatureServiceMetadataResponse;
import ai.tecton.client.response.GetFeaturesBatchResponse;
import ai.tecton.client.response.GetFeaturesResponse;
import ai.tecton.client.transport.HttpResponse;
import ai.tecton.client.transport.TectonHttpClient;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;

public class TectonClient {
    private final TectonHttpClient tectonHttpClient;

    public TectonClient(String url, String apiKey) {
        this.tectonHttpClient = new TectonHttpClient(url, apiKey, new TectonClientOptions.Builder().build());
    }

    public TectonClient(String url, String apiKey, TectonClientOptions tectonClientOptions) {
        this.tectonHttpClient = new TectonHttpClient(url, apiKey, tectonClientOptions);
    }

    public TectonClient(String url, String apiKey, OkHttpClient httpClient) {
        this.tectonHttpClient = new TectonHttpClient(url, apiKey, httpClient);
    }

    public GetFeaturesResponse getFeatures(GetFeaturesRequest getFeaturesRequest) throws TectonClientException, TectonServiceException {
        HttpResponse httpResponse = this.getHttpResponse(getFeaturesRequest);
        return new GetFeaturesResponse(httpResponse.getResponseBody().get(), httpResponse.getRequestDuration());
    }

    public GetFeatureServiceMetadataResponse getFeatureServiceMetadata(GetFeatureServiceMetadataRequest getFeatureServiceMetadataRequest) throws TectonClientException, TectonServiceException {
        HttpResponse httpResponse = this.getHttpResponse(getFeatureServiceMetadataRequest);
        return new GetFeatureServiceMetadataResponse(httpResponse.getResponseBody().get(), httpResponse.getRequestDuration());
    }

    public GetFeaturesBatchResponse getFeaturesBatch(GetFeaturesBatchRequest batchRequest) throws TectonClientException, TectonServiceException {
        List<String> requestList = batchRequest.getRequestList().stream().map(AbstractTectonRequest::requestToJson).collect(Collectors.toList());
        long start = System.currentTimeMillis();
        List<HttpResponse> httpResponseList = this.tectonHttpClient.performParallelRequests(batchRequest.getEndpoint(), batchRequest.getMethod(), requestList, batchRequest.getTimeout());
        long stop = System.currentTimeMillis();
        Duration totalTime = Duration.ofMillis(stop - start);
        return new GetFeaturesBatchResponse(httpResponseList, totalTime, batchRequest.getMicroBatchSize());
    }

    public void close() {
        if (!this.isClosed()) {
            this.tectonHttpClient.close();
        }
    }

    public boolean isClosed() {
        return this.tectonHttpClient.isClosed();
    }

    private HttpResponse getHttpResponse(AbstractTectonRequest tectonRequest) {
        HttpResponse httpResponse = this.tectonHttpClient.performRequest(tectonRequest.getEndpoint(), tectonRequest.getMethod(), tectonRequest.requestToJson());
        if (!httpResponse.isSuccessful()) {
            throw new TectonServiceException(String.format("Received Error Response from Tecton wih code %s and error message: %s", httpResponse.getResponseCode(), httpResponse.getMessage()));
        }
        if (!httpResponse.getResponseBody().isPresent()) {
            throw new TectonClientException("Received empty response body from Tecton");
        }
        return httpResponse;
    }

    public static class Builder {
        private String url;
        private String apiKey;
        private TectonClientOptions tectonClientOptions;
        private OkHttpClient httpClient;

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder tectonClientOptions(TectonClientOptions tectonClientOptions) {
            this.tectonClientOptions = tectonClientOptions;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public TectonClient build() {
            if (this.httpClient != null) {
                return new TectonClient(this.url, this.apiKey, this.httpClient);
            }
            if (this.tectonClientOptions != null) {
                return new TectonClient(this.url, this.apiKey, this.tectonClientOptions);
            }
            return new TectonClient(this.url, this.apiKey);
        }
    }
}

