/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.request.AbstractTectonRequest;
import ai.tecton.client.transport.TectonHttpClient;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;

public class GetFeatureServiceMetadataRequest
extends AbstractTectonRequest {
    private static final TectonHttpClient.HttpMethod method = TectonHttpClient.HttpMethod.POST;
    private static final String ENDPOINT = "/api/v1/feature-service/metadata";
    private static final String DEFAULT_WORKSPACE = "prod";
    private JsonAdapter<GetFeatureServiceMetadataJson> jsonAdapter;

    public GetFeatureServiceMetadataRequest(String featureServiceName, String workspaceName) {
        super(ENDPOINT, method, workspaceName, featureServiceName);
        Moshi moshi = new Moshi.Builder().build();
        this.jsonAdapter = moshi.adapter(GetFeatureServiceMetadataJson.class);
    }

    public GetFeatureServiceMetadataRequest(String featureServiceName) {
        super(ENDPOINT, method, DEFAULT_WORKSPACE, featureServiceName);
        Moshi moshi = new Moshi.Builder().build();
        this.jsonAdapter = moshi.adapter(GetFeatureServiceMetadataJson.class);
    }

    @Override
    public String requestToJson() {
        GetFeatureServiceMetadataFields serviceMetadataFields = new GetFeatureServiceMetadataFields();
        serviceMetadataFields.feature_service_name = super.getFeatureServiceName();
        serviceMetadataFields.workspace_name = super.getWorkspaceName();
        try {
            return this.jsonAdapter.toJson((Object)new GetFeatureServiceMetadataJson(serviceMetadataFields));
        }
        catch (Exception e) {
            throw new TectonClientException(String.format("The parameters passed to the GetFeatureServiceMetadataRequest are invalid. %s", e.getMessage()));
        }
    }

    public static final class Builder {
        private String workspaceName;
        private String featureServiceName;

        public Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public Builder featureServiceName(String featureServiceName) {
            this.featureServiceName = featureServiceName;
            return this;
        }

        public GetFeatureServiceMetadataRequest build() {
            return new GetFeatureServiceMetadataRequest(this.featureServiceName, this.workspaceName);
        }
    }

    static class GetFeatureServiceMetadataFields {
        String feature_service_name;
        String workspace_name;

        GetFeatureServiceMetadataFields() {
        }
    }

    static class GetFeatureServiceMetadataJson {
        GetFeatureServiceMetadataFields params;

        GetFeatureServiceMetadataJson(GetFeatureServiceMetadataFields params) {
            this.params = params;
        }
    }
}

