/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.MetadataOption;
import ai.tecton.client.request.AbstractGetFeaturesRequest;
import ai.tecton.client.request.GetFeaturesRequestData;
import ai.tecton.client.request.RequestConstants;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GetFeaturesRequest
extends AbstractGetFeaturesRequest {
    static final String ENDPOINT = "/api/v1/feature-service/get-features";
    private final JsonAdapter<GetFeaturesRequestJson> jsonAdapter;
    private final GetFeaturesRequestData getFeaturesRequestData;
    private final Moshi moshi = new Moshi.Builder().add(AbstractGetFeaturesRequest.SerializeNulls.JSON_ADAPTER_FACTORY).build();

    public GetFeaturesRequest(String workspaceName, String featureServiceName, GetFeaturesRequestData getFeaturesRequestData) {
        super(workspaceName, featureServiceName, ENDPOINT, RequestConstants.DEFAULT_METADATA_OPTIONS);
        GetFeaturesRequest.validateRequestParameters(getFeaturesRequestData);
        this.getFeaturesRequestData = getFeaturesRequestData;
        this.jsonAdapter = this.moshi.adapter(GetFeaturesRequestJson.class);
    }

    public GetFeaturesRequest(String workspaceName, String featureServiceName, GetFeaturesRequestData getFeaturesRequestData, Set<MetadataOption> metadataOptions) {
        super(workspaceName, featureServiceName, ENDPOINT, metadataOptions);
        GetFeaturesRequest.validateRequestParameters(getFeaturesRequestData);
        this.getFeaturesRequestData = getFeaturesRequestData;
        this.jsonAdapter = this.moshi.adapter(GetFeaturesRequestJson.class);
    }

    GetFeaturesRequestData getFeaturesRequestData() {
        return this.getFeaturesRequestData;
    }

    @Override
    public String requestToJson() {
        GetFeaturesFields getFeaturesFields = new GetFeaturesFields();
        getFeaturesFields.feature_service_name = this.getFeatureServiceName();
        getFeaturesFields.workspace_name = this.getWorkspaceName();
        if (!this.getFeaturesRequestData().isEmptyJoinKeyMap()) {
            getFeaturesFields.join_key_map = this.getFeaturesRequestData().getJoinKeyMap();
        }
        if (!this.getFeaturesRequestData().isEmptyRequestContextMap()) {
            getFeaturesFields.request_context_map = this.getFeaturesRequestData().getRequestContextMap();
        }
        if (!this.metadataOptions.isEmpty()) {
            getFeaturesFields.metadata_options = this.metadataOptions.stream().collect(Collectors.toMap(MetadataOption::getJsonName, a -> Boolean.TRUE));
        }
        GetFeaturesRequestJson getFeaturesRequestJson = new GetFeaturesRequestJson(getFeaturesFields);
        try {
            return this.jsonAdapter.toJson((Object)getFeaturesRequestJson);
        }
        catch (Exception e) {
            throw new TectonClientException(String.format("The parameters passed to the GetFeatureRequest are invalid. %s", e.getMessage()));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GetFeaturesRequest that = (GetFeaturesRequest)o;
        return this.getFeaturesRequestData.equals(that.getFeaturesRequestData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getFeaturesRequestData);
    }

    public static final class Builder {
        Set<MetadataOption> metadataOptions = new HashSet<MetadataOption>();
        private String workspaceName;
        private String featureServiceName;
        private GetFeaturesRequestData getFeaturesRequestData;

        public Builder metadataOptions(Set<MetadataOption> metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public Builder workspaceName(String workspaceName) {
            this.workspaceName = workspaceName;
            return this;
        }

        public Builder featureServiceName(String featureServiceName) {
            this.featureServiceName = featureServiceName;
            return this;
        }

        public Builder getFeaturesRequestData(GetFeaturesRequestData getFeaturesRequestData) {
            this.getFeaturesRequestData = getFeaturesRequestData;
            return this;
        }

        public GetFeaturesRequest build() {
            if (this.metadataOptions.isEmpty()) {
                return new GetFeaturesRequest(this.workspaceName, this.featureServiceName, this.getFeaturesRequestData);
            }
            return new GetFeaturesRequest(this.workspaceName, this.featureServiceName, this.getFeaturesRequestData, this.metadataOptions);
        }
    }

    static class GetFeaturesFields {
        String feature_service_name;
        String workspace_name;
        @AbstractGetFeaturesRequest.SerializeNulls
        Map<String, String> join_key_map;
        Map<String, Object> request_context_map;
        Map<String, Boolean> metadata_options;

        GetFeaturesFields() {
        }
    }

    static class GetFeaturesRequestJson {
        GetFeaturesFields params;

        GetFeaturesRequestJson(GetFeaturesFields params) {
            this.params = params;
        }
    }
}

