/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import ai.tecton.client.exceptions.InvalidRequestParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class GetFeaturesRequestData {
    private Map<String, String> joinKeyMap = new HashMap<String, String>();
    private Map<String, Object> requestContextMap = new HashMap<String, Object>();

    public GetFeaturesRequestData addJoinKeyMap(Map<String, String> joinKeyMap) throws InvalidRequestParameterException {
        Validate.notEmpty(joinKeyMap);
        joinKeyMap.forEach(this::validateKeyValue);
        this.joinKeyMap = joinKeyMap;
        return this;
    }

    public GetFeaturesRequestData addRequestContextMap(Map<String, Object> requestContextMap) throws InvalidRequestParameterException {
        Validate.notEmpty(requestContextMap);
        requestContextMap.forEach(this::validateKeyValueDisallowingNullValue);
        this.requestContextMap = requestContextMap;
        return this;
    }

    public GetFeaturesRequestData addJoinKey(String key, String value) throws InvalidRequestParameterException {
        this.validateKeyValue(key, value);
        this.joinKeyMap.put(key, value);
        return this;
    }

    public GetFeaturesRequestData addJoinKey(String key, Long value) throws InvalidRequestParameterException {
        String joinKeyValue = value == null ? null : value.toString();
        this.validateKeyValue(key, joinKeyValue);
        this.joinKeyMap.put(key, joinKeyValue);
        return this;
    }

    public GetFeaturesRequestData addRequestContext(String key, String value) throws InvalidRequestParameterException {
        this.validateKeyValueDisallowingNullValue(key, value);
        this.requestContextMap.put(key, value);
        return this;
    }

    public GetFeaturesRequestData addRequestContext(String key, Long value) throws InvalidRequestParameterException {
        this.validateKeyValueDisallowingNullValue(key, value);
        this.requestContextMap.put(key, value.toString());
        return this;
    }

    public GetFeaturesRequestData addRequestContext(String key, Double value) throws InvalidRequestParameterException {
        this.validateKeyValueDisallowingNullValue(key, value);
        this.requestContextMap.put(key, value);
        return this;
    }

    public Map<String, String> getJoinKeyMap() {
        return Collections.unmodifiableMap(this.joinKeyMap);
    }

    public Map<String, Object> getRequestContextMap() {
        return Collections.unmodifiableMap(this.requestContextMap);
    }

    public boolean isEmptyJoinKeyMap() {
        return this.joinKeyMap.isEmpty();
    }

    public boolean isEmptyRequestContextMap() {
        return this.requestContextMap.isEmpty();
    }

    private void validateKeyValue(String key, Object value) {
        try {
            Validate.notEmpty((CharSequence)key, (String)"Key/Value cannot be null or empty", (Object[])new Object[0]);
            if (value instanceof String) {
                Validate.notEmpty((CharSequence)((String)value), (String)"Key/Value cannot be null or empty", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new InvalidRequestParameterException(e.getMessage());
        }
    }

    private void validateKeyValueDisallowingNullValue(String key, Object value) {
        try {
            this.validateKeyValue(key, value);
            Validate.notNull((Object)value, (String)"Key/Value cannot be null or empty", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidRequestParameterException(e.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetFeaturesRequestData that = (GetFeaturesRequestData)o;
        return Objects.equals(this.joinKeyMap, that.joinKeyMap) && Objects.equals(this.requestContextMap, that.requestContextMap);
    }

    public int hashCode() {
        return Objects.hash(this.joinKeyMap, this.requestContextMap);
    }

    public static class Builder {
        private GetFeaturesRequestData getFeaturesRequestData = new GetFeaturesRequestData();

        public Builder joinKeyMap(Map<String, String> joinKeyMap) {
            this.getFeaturesRequestData = this.getFeaturesRequestData.addJoinKeyMap(joinKeyMap);
            return this;
        }

        public Builder requestContextMap(Map<String, Object> requestContextMap) {
            this.getFeaturesRequestData = this.getFeaturesRequestData.addRequestContextMap(requestContextMap);
            return this;
        }

        public GetFeaturesRequestData build() {
            return this.getFeaturesRequestData;
        }
    }
}

