/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.response;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.FeatureStatus;
import ai.tecton.client.model.FeatureValue;
import ai.tecton.client.response.AbstractTectonResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class GetFeaturesResponseUtils {
    private static final String NAME = "Name";
    private static final String DATA_TYPE = "Data Type";

    GetFeaturesResponseUtils() {
    }

    static List<FeatureValue> constructFeatureVector(List<Object> features, List<FeatureMetadata> featureMetadata, int index) {
        GetFeaturesResponseUtils.validateResponse(features, featureMetadata);
        ArrayList<FeatureValue> featureValues = new ArrayList<FeatureValue>(features.size());
        for (int i = 0; i < features.size(); ++i) {
            FeatureValue value = new FeatureValue(features.get(i), featureMetadata.get((int)i).name, featureMetadata.get((int)i).dataType.getDataType(), featureMetadata.get((int)i).dataType.getListElementType(), featureMetadata.get((int)i).effectiveTime, featureMetadata.get((int)i).status != null ? FeatureStatus.fromString(featureMetadata.get((int)i).status.get(index)) : null);
            featureValues.add(value);
        }
        return featureValues;
    }

    static void validateResponse(List<Object> featureVector, List<FeatureMetadata> featureMetadata) {
        if (featureVector.isEmpty()) {
            throw new TectonClientException("Received empty feature vector from Tecton");
        }
        for (FeatureMetadata metadata : featureMetadata) {
            if (StringUtils.isEmpty((CharSequence)metadata.name)) {
                throw new TectonClientException(String.format("Required metadata %s is missing in the response", NAME));
            }
            if (!StringUtils.isEmpty((CharSequence)metadata.dataType.type)) continue;
            throw new TectonClientException(String.format("Required metadata %s is missing in the response", DATA_TYPE));
        }
    }

    static class FeatureVectorJson {
        List<Object> features;

        FeatureVectorJson() {
        }
    }

    static class FeatureMetadata {
        String name;
        String effectiveTime;
        AbstractTectonResponse.ResponseDataType dataType = new AbstractTectonResponse.ResponseDataType();
        List<String> status;

        FeatureMetadata() {
        }
    }
}

