/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.response;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.FeatureServiceMetadata;
import ai.tecton.client.model.NameAndType;
import ai.tecton.client.model.ValueType;
import ai.tecton.client.response.AbstractTectonResponse;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class GetFeatureServiceMetadataResponse
extends AbstractTectonResponse {
    private FeatureServiceMetadata featureServiceMetadata;
    private final JsonAdapter<GetFeatureServiceMetadataJson> jsonAdapter;

    public GetFeatureServiceMetadataResponse(String response, Duration requestLatency) {
        super(requestLatency);
        Moshi moshi = new Moshi.Builder().build();
        this.jsonAdapter = moshi.adapter(GetFeatureServiceMetadataJson.class);
        this.buildResponseFromJson(response);
    }

    public FeatureServiceMetadata getFeatureServiceMetadata() {
        return this.featureServiceMetadata;
    }

    @Override
    void buildResponseFromJson(String response) {
        try {
            GetFeatureServiceMetadataJson featureServiceMetadataJson = (GetFeatureServiceMetadataJson)this.jsonAdapter.fromJson(response);
            this.featureServiceMetadata = new FeatureServiceMetadata(this.parseNameAndType(featureServiceMetadataJson.inputJoinKeys), this.parseNameAndType(featureServiceMetadataJson.inputRequestContextKeys), this.parseNameAndType(featureServiceMetadataJson.featureValues));
        }
        catch (IOException | NullPointerException e) {
            throw new TectonClientException("Unable to parse JSON response from Tecton");
        }
    }

    private List<NameAndType> parseNameAndType(List<NameAndTypeJson> nameAndTypeJson) {
        ArrayList<NameAndType> nameAndTypeList = new ArrayList<NameAndType>();
        if (nameAndTypeJson != null) {
            nameAndTypeJson.forEach(nt -> {
                ValueType dataValueType = nt.dataType.getDataType();
                if (dataValueType == ValueType.ARRAY) {
                    ValueType elementValueType = nt.dataType.getListElementType().get();
                    nameAndTypeList.add(new NameAndType(nt.name, dataValueType, elementValueType));
                } else {
                    nameAndTypeList.add(new NameAndType(nt.name, dataValueType));
                }
            });
        }
        return nameAndTypeList;
    }

    static class NameAndTypeJson {
        String name;
        AbstractTectonResponse.ResponseDataType dataType = new AbstractTectonResponse.ResponseDataType();

        NameAndTypeJson() {
        }
    }

    static class GetFeatureServiceMetadataJson {
        private String featureServiceType;
        private List<NameAndTypeJson> inputJoinKeys;
        private List<NameAndTypeJson> inputRequestContextKeys;
        private List<NameAndTypeJson> outputJoinKeys;
        private List<NameAndTypeJson> featureValues;
        private String type;

        GetFeatureServiceMetadataJson() {
        }
    }
}

