/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.model;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SloInformation {
    private Boolean sloEligible;
    private Double serverTimeSeconds;
    private Double sloServerTimeSeconds;
    private Integer storeResponseSizeBytes;
    private Set<SloIneligibilityReason> sloIneligibilityReasons;
    private Double storeMaxLatency;

    public SloInformation(Boolean isSloEligible, Double serverTimeSeconds, Double sloServerTimeSeconds, Integer storeResponseSizeBytes, Set<SloIneligibilityReason> sloIneligibilityReasons, Double storeMaxLatency) {
        this.sloEligible = isSloEligible;
        this.serverTimeSeconds = serverTimeSeconds;
        this.sloServerTimeSeconds = sloServerTimeSeconds;
        this.sloIneligibilityReasons = sloIneligibilityReasons;
        this.storeResponseSizeBytes = storeResponseSizeBytes;
        this.storeMaxLatency = storeMaxLatency;
    }

    public Optional<Boolean> isSloEligible() {
        return Optional.ofNullable(this.sloEligible);
    }

    public Set<SloIneligibilityReason> getSloIneligibilityReasons() {
        return this.sloIneligibilityReasons == null ? Collections.emptySet() : this.sloIneligibilityReasons;
    }

    public Optional<Double> getServerTimeSeconds() {
        return Optional.ofNullable(this.serverTimeSeconds);
    }

    public Optional<Double> getStoreMaxLatency() {
        return Optional.ofNullable(this.storeMaxLatency);
    }

    public Optional<Integer> getStoreResponseSizeBytes() {
        return Optional.ofNullable(this.storeResponseSizeBytes);
    }

    public Optional<Double> getSloServerTimeSeconds() {
        return Optional.ofNullable(this.sloServerTimeSeconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SloInformation that = (SloInformation)o;
        return Objects.equals(this.sloEligible, that.sloEligible) && Objects.equals(this.serverTimeSeconds, that.serverTimeSeconds) && Objects.equals(this.sloServerTimeSeconds, that.sloServerTimeSeconds) && Objects.equals(this.storeResponseSizeBytes, that.storeResponseSizeBytes) && Objects.equals(this.sloIneligibilityReasons, that.sloIneligibilityReasons) && Objects.equals(this.storeMaxLatency, that.storeMaxLatency);
    }

    public int hashCode() {
        return Objects.hash(this.sloEligible, this.serverTimeSeconds, this.sloServerTimeSeconds, this.storeResponseSizeBytes, this.sloIneligibilityReasons, this.storeMaxLatency);
    }

    public static class Builder {
        Boolean isSloEligible;
        Double serverTimeSeconds;
        Double sloServerTimeSeconds;
        Integer storeResponseSizeByte;
        Set<SloIneligibilityReason> sloIneligibilityReasons;
        Double storeMaxLatency;

        public Builder isSloEligible(boolean isSloEligible) {
            this.isSloEligible = isSloEligible;
            return this;
        }

        public Builder serverTimeSeconds(Double serverTimeSeconds) {
            this.serverTimeSeconds = serverTimeSeconds;
            return this;
        }

        public Builder sloServerTimeSeconds(Double sloServerTimeSeconds) {
            this.sloServerTimeSeconds = sloServerTimeSeconds;
            return this;
        }

        public Builder storeResponseSizeBytes(Integer storeResponseSizeByte) {
            this.storeResponseSizeByte = storeResponseSizeByte;
            return this;
        }

        public Builder sloIneligibilityReasons(Set<SloIneligibilityReason> sloIneligibilityReasons) {
            this.sloIneligibilityReasons = sloIneligibilityReasons;
            return this;
        }

        public Builder storeMaxLatency(Double storeMaxLatency) {
            this.storeMaxLatency = storeMaxLatency;
            return this;
        }

        public SloInformation build() {
            return new SloInformation(this.isSloEligible, this.serverTimeSeconds, this.sloServerTimeSeconds, this.storeResponseSizeByte, this.sloIneligibilityReasons, this.storeMaxLatency);
        }
    }

    public static enum SloIneligibilityReason {
        UNKNOWN,
        DYNAMODB_RESPONSE_SIZE_LIMIT_EXCEEDED,
        REDIS_RESPONSE_SIZE_LIMIT_EXCEEDED,
        REDIS_LATENCY_LIMIT_EXCEEDED;

    }
}

