/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.model;

import ai.tecton.client.model.NameAndType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FeatureServiceMetadata {
    private final List<NameAndType> inputJoinKeys;
    private final List<NameAndType> inputRequestContextKeys;
    private final List<NameAndType> featureValues;

    public FeatureServiceMetadata(List<NameAndType> inputJoinKeys, List<NameAndType> inputRequestContextKeys, List<NameAndType> featureValues) {
        this.inputJoinKeys = inputJoinKeys;
        this.inputRequestContextKeys = inputRequestContextKeys;
        this.featureValues = featureValues;
    }

    public List<NameAndType> getInputJoinKeys() {
        return this.inputJoinKeys;
    }

    public List<NameAndType> getInputRequestContextKeys() {
        return this.inputRequestContextKeys;
    }

    public List<NameAndType> getFeatureValues() {
        return this.featureValues;
    }

    public Map<String, NameAndType> getInputJoinKeysAsMap() {
        return this.inputJoinKeys.stream().collect(Collectors.toMap(NameAndType::getName, Function.identity()));
    }

    public Map<String, NameAndType> getInputRequestContextKeysAsMap() {
        return this.inputRequestContextKeys.stream().collect(Collectors.toMap(NameAndType::getName, Function.identity()));
    }

    public Map<String, NameAndType> getFeatureValuesAsMap() {
        return this.featureValues.stream().collect(Collectors.toMap(NameAndType::getName, Function.identity()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureServiceMetadata that = (FeatureServiceMetadata)o;
        return Objects.equals(this.inputJoinKeys, that.inputJoinKeys) && Objects.equals(this.inputRequestContextKeys, that.inputRequestContextKeys) && Objects.equals(this.featureValues, that.featureValues);
    }

    public int hashCode() {
        return Objects.hash(this.inputJoinKeys, this.inputRequestContextKeys, this.featureValues);
    }
}

