/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.model;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.FeatureStatus;
import ai.tecton.client.model.ListDataType;
import ai.tecton.client.model.ValueType;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class FeatureValue {
    private final String featureNamespace;
    private final String featureName;
    private Instant effectiveTime;
    private final Value value;
    private final Optional<FeatureStatus> featureStatus;
    private final String featureDescription;
    private final Map<String, String> featureTags;

    public FeatureValue(Object featureObject, String name, ValueType valueType, Optional<ValueType> elementValueType, String effectiveTime, Optional<FeatureStatus> featureStatus, String featureDescription, Map<String, String> featureTags) {
        String[] split = StringUtils.split((String)name, (String)".");
        this.featureNamespace = split[0];
        this.featureName = split[1];
        this.featureStatus = featureStatus;
        this.featureDescription = featureDescription;
        this.featureTags = featureTags;
        try {
            if (StringUtils.isNotEmpty((CharSequence)effectiveTime)) {
                this.effectiveTime = OffsetDateTime.parse(effectiveTime).toInstant();
            }
        }
        catch (Exception e) {
            throw new TectonClientException("Unable to parse effectiveTime in the response metadata");
        }
        try {
            switch (valueType) {
                case ARRAY: {
                    this.value = new Value(featureObject, valueType, elementValueType.get());
                    break;
                }
                default: {
                    this.value = new Value(featureObject, valueType);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TectonClientException(String.format("Unable to cast response for field %s to expected type %s (value: %s)", name, valueType.getName(), featureObject));
        }
    }

    public ValueType getValueType() {
        return this.value.valueType;
    }

    public Optional<ValueType> getListElementType() {
        return Optional.ofNullable(((Value)this.value).listValue.listElementType);
    }

    public Optional<FeatureStatus> getFeatureStatus() {
        return this.featureStatus;
    }

    public String getFeatureDescription() {
        return this.featureDescription;
    }

    public Map<String, String> getFeatureTags() {
        return this.featureTags;
    }

    public Optional<Instant> getEffectiveTime() {
        return Optional.ofNullable(this.effectiveTime);
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureNamespace() {
        return this.featureNamespace;
    }

    public String stringValue() throws TectonClientException {
        this.validateValueType(ValueType.STRING);
        return this.value.stringValue;
    }

    public Long int64value() throws TectonClientException {
        this.validateValueType(ValueType.INT64);
        return this.value.int64Value;
    }

    public Boolean booleanValue() throws TectonClientException {
        this.validateValueType(ValueType.BOOLEAN);
        return this.value.booleanValue;
    }

    public Double float64Value() throws TectonClientException {
        this.validateValueType(ValueType.FLOAT64);
        return this.value.float64Value;
    }

    public List<Double> float64ArrayValue() throws TectonClientException {
        this.validateValueType(ValueType.ARRAY, ValueType.FLOAT64);
        return ((Value)this.value).listValue.float64List;
    }

    public List<Float> float32ArrayValue() throws TectonClientException {
        this.validateValueType(ValueType.ARRAY, ValueType.FLOAT32);
        return ((Value)this.value).listValue.float32List;
    }

    public List<Long> int64ArrayValue() throws TectonClientException {
        this.validateValueType(ValueType.ARRAY, ValueType.INT64);
        return ((Value)this.value).listValue.int64List;
    }

    public List<String> stringArrayValue() throws TectonClientException {
        this.validateValueType(ValueType.ARRAY, ValueType.STRING);
        return ((Value)this.value).listValue.stringList;
    }

    private void validateValueType(ValueType valueType) {
        if (this.value.valueType != valueType) {
            throw new TectonClientException(String.format("Invalid method used to access value of type %s", this.value.valueType.getName()));
        }
    }

    private void validateValueType(ValueType valueType, ValueType elementType) {
        this.validateValueType(valueType);
        if (((Value)this.value).listValue.listElementType != elementType) {
            throw new TectonClientException(String.format("Invalid method used to access value of type %s", ((Value)this.value).listValue.listElementType.getName()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureValue that = (FeatureValue)o;
        return Objects.equals(this.featureNamespace, that.featureNamespace) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.effectiveTime, that.effectiveTime) && Objects.equals(this.value, that.value) && Objects.equals(this.featureStatus, that.featureStatus);
    }

    public int hashCode() {
        return Objects.hash(this.featureNamespace, this.featureName, this.effectiveTime, this.value, this.featureStatus);
    }

    class Value {
        private final ValueType valueType;
        private String stringValue;
        private Long int64Value;
        private Boolean booleanValue;
        private Double float64Value;
        private ListDataType listValue;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.valueType == value.valueType && Objects.equals(this.stringValue, value.stringValue) && Objects.equals(this.int64Value, value.int64Value) && Objects.equals(this.booleanValue, value.booleanValue) && Objects.equals(this.float64Value, value.float64Value) && Objects.equals(this.listValue, value.listValue);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.valueType, this.stringValue, this.int64Value, this.booleanValue, this.float64Value, this.listValue});
        }

        public Value(Object featureObject, ValueType valueType) {
            this.valueType = valueType;
            switch (valueType) {
                case BOOLEAN: {
                    this.booleanValue = (Boolean)featureObject;
                    break;
                }
                case STRING: {
                    this.stringValue = (String)featureObject;
                    break;
                }
                case INT64: {
                    String stringValue = (String)featureObject;
                    if (stringValue == null) break;
                    this.int64Value = Long.parseLong(stringValue);
                    break;
                }
                case FLOAT64: {
                    if (featureObject instanceof String) {
                        String doubleString = (String)featureObject;
                        if (doubleString.equals("null") || doubleString.equals("NaN") || doubleString.equals("Infinity") || doubleString.equals("-Infinity")) {
                            this.float64Value = null;
                            break;
                        }
                        this.float64Value = Double.valueOf(doubleString);
                        break;
                    }
                    this.float64Value = (Double)featureObject;
                    break;
                }
                default: {
                    throw new TectonClientException(String.format("Unknown Data Type %s in response", valueType.getName()));
                }
            }
        }

        Value(Object featureObject, ValueType valueType, ValueType listElementType) {
            this.valueType = valueType;
            this.listValue = new ListDataType(listElementType, featureObject);
        }
    }
}

