/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RequestOptions {
    private Map<String, Object> options = new HashMap<String, Object>();

    public RequestOptions setOption(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Option value must not be null: " + key);
        }
        this.options.put(key, value);
        return this;
    }

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public Map<String, Object> getOptions() {
        return new HashMap<String, Object>(this.options);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOptions that = (RequestOptions)o;
        return Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.options);
    }

    public String toString() {
        return "RequestOptions{options=" + this.options + '}';
    }

    public static class Builder {
        private RequestOptions requestOptions = new RequestOptions();

        public Builder option(String key, Object value) {
            this.requestOptions.setOption(key, value);
            return this;
        }

        public RequestOptions build() {
            return this.requestOptions;
        }
    }
}

