/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.response;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.FeatureStatus;
import ai.tecton.client.model.FeatureValue;
import ai.tecton.client.model.SloInformation;
import ai.tecton.client.response.AbstractTectonResponse;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class GetFeaturesResponse
extends AbstractTectonResponse {
    private final List<FeatureValue> featureValues;
    private SloInformation sloInformation;
    private final JsonAdapter<GetFeaturesResponseJson> jsonAdapter;
    private static final String NAME = "Name";
    private static final String DATA_TYPE = "Data Type";

    public GetFeaturesResponse(String response, Duration requestLatency) throws TectonClientException {
        super(requestLatency);
        Moshi moshi = new Moshi.Builder().build();
        this.jsonAdapter = moshi.adapter(GetFeaturesResponseJson.class);
        this.featureValues = new ArrayList<FeatureValue>();
        this.buildResponseFromJson(response);
    }

    GetFeaturesResponse(List<FeatureValue> featureValues, Duration requestLatency) {
        super(requestLatency);
        this.featureValues = featureValues;
        Moshi moshi = new Moshi.Builder().build();
        this.jsonAdapter = moshi.adapter(GetFeaturesResponseJson.class);
    }

    public List<FeatureValue> getFeatureValues() {
        return this.featureValues;
    }

    public Map<String, FeatureValue> getFeatureValuesAsMap() {
        HashMap<String, FeatureValue> featureMap = new HashMap<String, FeatureValue>();
        this.featureValues.forEach(featureValue -> featureMap.put(StringUtils.join((Object[])new String[]{featureValue.getFeatureNamespace(), ".", featureValue.getFeatureName()}), (FeatureValue)featureValue));
        return featureMap;
    }

    public Optional<SloInformation> getSloInformation() {
        return Optional.ofNullable(this.sloInformation);
    }

    @Override
    void buildResponseFromJson(String response) {
        GetFeaturesResponseJson responseJson;
        try {
            responseJson = (GetFeaturesResponseJson)this.jsonAdapter.fromJson(response);
        }
        catch (IOException e) {
            throw new TectonClientException("Unable to parse JSON response from Tecton");
        }
        List<Object> featureVector = responseJson.result.features;
        List<GetFeaturesResponseJson.FeatureMetadata> featureMetadata = responseJson.metadata.features;
        this.validateResponse(featureVector, featureMetadata);
        for (int i = 0; i < responseJson.result.features.size(); ++i) {
            FeatureValue value = new FeatureValue(featureVector.get(i), featureMetadata.get((int)i).name, featureMetadata.get((int)i).dataType.getDataType(), featureMetadata.get((int)i).dataType.getListElementType(), featureMetadata.get((int)i).effectiveTime, FeatureStatus.fromString(featureMetadata.get((int)i).status), featureMetadata.get((int)i).description, featureMetadata.get((int)i).tags);
            this.featureValues.add(value);
        }
        if (responseJson.metadata.sloInfo != null) {
            this.sloInformation = responseJson.metadata.sloInfo;
        }
    }

    void setSloInformation(SloInformation sloInformation) {
        this.sloInformation = sloInformation;
    }

    private void validateResponse(List<Object> featureVector, List<GetFeaturesResponseJson.FeatureMetadata> featureMetadata) {
        if (featureVector.isEmpty()) {
            throw new TectonClientException("Received empty feature vector from Tecton");
        }
        for (GetFeaturesResponseJson.FeatureMetadata metadata : featureMetadata) {
            if (StringUtils.isEmpty((CharSequence)metadata.name)) {
                throw new TectonClientException(String.format("Required metadata %s is missing in the response", NAME));
            }
            if (!StringUtils.isEmpty((CharSequence)metadata.dataType.type)) continue;
            throw new TectonClientException(String.format("Required metadata %s is missing in the response", DATA_TYPE));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetFeaturesResponse that = (GetFeaturesResponse)o;
        return Objects.equals(this.featureValues, that.featureValues) && Objects.equals(this.sloInformation, that.sloInformation);
    }

    public int hashCode() {
        return Objects.hash(this.featureValues, this.sloInformation);
    }

    static class GetFeaturesResponseJson {
        Result result;
        ResponseMetadata metadata;

        GetFeaturesResponseJson() {
        }

        static class FeatureMetadata {
            String name;
            String effectiveTime;
            AbstractTectonResponse.ResponseDataType dataType = new AbstractTectonResponse.ResponseDataType();
            String status;
            String description;
            Map<String, String> tags;

            FeatureMetadata() {
            }
        }

        static class ResponseMetadata {
            List<FeatureMetadata> features;
            SloInformation sloInfo;

            ResponseMetadata() {
            }
        }

        static class Result {
            List<Object> features;

            Result() {
            }
        }
    }
}

