/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.GroupLexer;
import org.antlr.stringtemplate.language.GroupParser;

public class StringTemplateGroup {
    protected String name;
    protected Map templates = new HashMap();
    protected Class templateLexerClass = class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = StringTemplateGroup.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer;
    protected String rootDir = null;
    protected static Map nameToGroupMap = new HashMap();
    protected StringTemplateGroup superGroup = null;
    protected boolean templatesDefinedInGroupFile = false;
    protected Class userSpecifiedWriter;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String string, Throwable throwable) {
            System.err.println(string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }

        public void warning(String string) {
            System.out.println(string);
        }

        public void debug(String string) {
            System.out.println(string);
        }
    };
    protected static final StringTemplate NOT_FOUND_ST = new StringTemplate();
    protected int refreshIntervalInSeconds = 2147483;
    protected long lastCheckedDisk = 0L;
    String fileCharEncoding = System.getProperty("file.encoding");
    static /* synthetic */ Class class$org$antlr$stringtemplate$language$DefaultTemplateLexer;
    static /* synthetic */ Class class$java$io$Writer;

    public StringTemplateGroup(String string, String string2) {
        this(string, string2, class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = StringTemplateGroup.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
    }

    public StringTemplateGroup(String string, String string2, Class clazz) {
        this.name = string;
        this.rootDir = string2;
        this.lastCheckedDisk = System.currentTimeMillis();
        nameToGroupMap.put(string, this);
        this.templateLexerClass = clazz;
    }

    public StringTemplateGroup(String string) {
        this(string, null, class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = StringTemplateGroup.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer);
    }

    public StringTemplateGroup(String string, Class clazz) {
        this(string, null, clazz);
    }

    public StringTemplateGroup(Reader reader) {
        this(reader, class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = StringTemplateGroup.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, DEFAULT_ERROR_LISTENER);
    }

    public StringTemplateGroup(Reader reader, StringTemplateErrorListener stringTemplateErrorListener) {
        this(reader, class$org$antlr$stringtemplate$language$DefaultTemplateLexer == null ? (class$org$antlr$stringtemplate$language$DefaultTemplateLexer = StringTemplateGroup.class$("org.antlr.stringtemplate.language.DefaultTemplateLexer")) : class$org$antlr$stringtemplate$language$DefaultTemplateLexer, stringTemplateErrorListener);
    }

    public StringTemplateGroup(Reader reader, Class clazz) {
        this(reader, clazz, null);
    }

    public StringTemplateGroup(Reader reader, Class clazz, StringTemplateErrorListener stringTemplateErrorListener) {
        this.templatesDefinedInGroupFile = true;
        this.templateLexerClass = clazz;
        this.listener = stringTemplateErrorListener;
        this.parseGroup(reader);
    }

    public Class getTemplateLexerClass() {
        return this.templateLexerClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSuperGroup(StringTemplateGroup stringTemplateGroup) {
        this.superGroup = stringTemplateGroup;
    }

    public void setSuperGroup(String string) {
        this.superGroup = (StringTemplateGroup)nameToGroupMap.get(string);
    }

    public StringTemplateGroup getSuperGroup() {
        return this.superGroup;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String string) {
        this.rootDir = string;
    }

    public StringTemplate createStringTemplate() {
        return new StringTemplate();
    }

    public StringTemplate getInstanceOf(String string) throws IllegalArgumentException {
        StringTemplate stringTemplate = this.lookupTemplate(string);
        return stringTemplate.getInstanceOf();
    }

    public StringTemplate getEmbeddedInstanceOf(StringTemplate stringTemplate, String string) throws IllegalArgumentException {
        StringTemplate stringTemplate2 = this.getInstanceOf(string);
        stringTemplate2.setEnclosingInstance(stringTemplate);
        return stringTemplate2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringTemplate lookupTemplate(String string) throws IllegalArgumentException {
        if (StringTemplate.debugMode) {
            this.listener.debug("lookupTemplate(" + string + ")");
        }
        if (string.startsWith("super.")) {
            if (this.superGroup == null) throw new IllegalArgumentException(this.getName() + " has no super group; invalid template: " + string);
            int n = string.indexOf(46);
            string = string.substring(n + 1, string.length());
            return this.superGroup.lookupTemplate(string);
        }
        this.checkRefreshInterval();
        StringTemplate stringTemplate = (StringTemplate)this.templates.get(string);
        if (stringTemplate != null) {
            if (stringTemplate != NOT_FOUND_ST) return stringTemplate;
            return null;
        }
        if (StringTemplate.debugMode) {
            this.listener.debug("Attempting load of: " + this.getFileNameFromTemplateName(string));
        }
        if (!this.templatesDefinedInGroupFile) {
            stringTemplate = this.loadTemplateFromBeneathRootDirOrCLASSPATH(this.getFileNameFromTemplateName(string));
        }
        if (stringTemplate == null && this.superGroup != null && (stringTemplate = this.superGroup.getInstanceOf(string)) != null) {
            stringTemplate.setGroup(this);
        }
        if (stringTemplate != null) {
            this.templates.put(string, stringTemplate);
            return stringTemplate;
        }
        this.templates.put(string, NOT_FOUND_ST);
        throw new IllegalArgumentException("Can't load template " + this.getFileNameFromTemplateName(string));
    }

    protected void checkRefreshInterval() {
        boolean bl;
        if (this.templatesDefinedInGroupFile) {
            return;
        }
        boolean bl2 = bl = this.refreshIntervalInSeconds == 0 || System.currentTimeMillis() - this.lastCheckedDisk >= (long)(this.refreshIntervalInSeconds * 1000);
        if (bl) {
            this.templates.clear();
            this.lastCheckedDisk = System.currentTimeMillis();
        }
    }

    protected StringTemplate loadTemplate(String string, BufferedReader bufferedReader) throws IOException {
        String string2;
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(300);
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string3);
        }
        String string4 = stringBuffer.toString().trim();
        if (string4.length() == 0) {
            this.error("no text in template '" + string + "'");
            return null;
        }
        return this.defineTemplate(string, string4);
    }

    protected StringTemplate loadTemplateFromBeneathRootDirOrCLASSPATH(String string) {
        StringTemplate stringTemplate = null;
        String string2 = this.getTemplateNameFromFileName(string);
        if (this.rootDir == null) {
            block6: {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string);
                if (inputStream == null) {
                    return null;
                }
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(this.getInputStreamReader(inputStream));
                    stringTemplate = this.loadTemplate(string2, bufferedReader);
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    if (bufferedReader == null) break block6;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        this.error("Cannot close template file: " + string);
                    }
                }
            }
            return stringTemplate;
        }
        stringTemplate = this.loadTemplate(string2, this.rootDir + "/" + string);
        return stringTemplate;
    }

    public String getFileNameFromTemplateName(String string) {
        return string + ".st";
    }

    public String getTemplateNameFromFileName(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(".st");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected StringTemplate loadTemplate(String string, String string2) {
        StringTemplate stringTemplate;
        block4: {
            BufferedReader bufferedReader = null;
            stringTemplate = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                InputStreamReader inputStreamReader = this.getInputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                stringTemplate = this.loadTemplate(string, bufferedReader);
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException) {
                if (bufferedReader == null) break block4;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    this.error("Cannot close template file: " + string2);
                }
            }
        }
        return stringTemplate;
    }

    protected InputStreamReader getInputStreamReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return inputStreamReader;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String string) {
        this.fileCharEncoding = string;
    }

    public StringTemplate defineTemplate(String string, String string2) {
        if (StringTemplate.debugMode) {
            this.listener.debug(this.getName() + ".defineTemplate(" + string + ")");
        }
        StringTemplate stringTemplate = this.createStringTemplate();
        stringTemplate.setName(string);
        stringTemplate.setGroup(this);
        stringTemplate.setTemplate(string2);
        stringTemplate.setErrorListener(this.listener);
        this.templates.put(string, stringTemplate);
        return stringTemplate;
    }

    public StringTemplate defineTemplateAlias(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateDefinition(string2);
        if (stringTemplate == null) {
            this.error("cannot alias " + string + " to undefined template: " + string2);
            return null;
        }
        this.templates.put(string, stringTemplate);
        return stringTemplate;
    }

    public boolean isDefinedInThisGroup(String string) {
        return this.templates.get(string) != null;
    }

    public StringTemplate getTemplateDefinition(String string) {
        return (StringTemplate)this.templates.get(string);
    }

    public boolean isDefined(String string) {
        try {
            this.lookupTemplate(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    protected void parseGroup(Reader reader) {
        try {
            GroupLexer groupLexer = new GroupLexer(reader);
            GroupParser groupParser = new GroupParser(groupLexer);
            groupParser.group(this);
        }
        catch (Exception exception) {
            String string = "<unknown>";
            if (this.getName() != null) {
                string = this.getName();
            }
            this.error("problem parsing group '" + string + "'", exception);
        }
    }

    public int getRefreshInterval() {
        return this.refreshIntervalInSeconds;
    }

    public void setRefreshInterval(int n) {
        this.refreshIntervalInSeconds = n;
    }

    public void setErrorListener(StringTemplateErrorListener stringTemplateErrorListener) {
        this.listener = stringTemplateErrorListener;
    }

    public StringTemplateErrorListener getErrorListener() {
        return this.listener;
    }

    public void setStringTemplateWriter(Class clazz) {
        this.userSpecifiedWriter = clazz;
    }

    public StringTemplateWriter getStringTemplateWriter(Writer writer) {
        StringTemplateWriter stringTemplateWriter = null;
        if (this.userSpecifiedWriter != null) {
            try {
                Constructor constructor = this.userSpecifiedWriter.getConstructor(class$java$io$Writer == null ? (class$java$io$Writer = StringTemplateGroup.class$("java.io.Writer")) : class$java$io$Writer);
                stringTemplateWriter = (StringTemplateWriter)constructor.newInstance(writer);
            }
            catch (Exception exception) {
                this.error("problems getting StringTemplateWriter", exception);
            }
        }
        if (stringTemplateWriter == null) {
            stringTemplateWriter = new AutoIndentWriter(writer);
        }
        return stringTemplateWriter;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        if (this.listener != null) {
            this.listener.error(string, exception);
        } else {
            System.err.println("StringTemplate: " + string + ": " + exception);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.templates.keySet().iterator();
        stringBuffer.append("group " + this.getName() + ";\n");
        StringTemplate stringTemplate = new StringTemplate("$args;separator=\",\"$");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTemplate stringTemplate2 = (StringTemplate)this.templates.get(string);
            if (stringTemplate2 == NOT_FOUND_ST) continue;
            stringTemplate = stringTemplate.getInstanceOf();
            stringTemplate.setAttribute("args", stringTemplate2.getFormArguments());
            stringBuffer.append(string + "(" + stringTemplate + ") ::= ");
            stringBuffer.append("<<");
            stringBuffer.append(stringTemplate2.getTemplate());
            stringBuffer.append(">>\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

