/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.language;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.ASTExpr;

public class AttributeReflectionController {
    protected Set typesVisited;
    protected StringBuffer output;
    protected int indentation = 0;
    protected Stack itemIndexStack = new Stack();
    protected StringTemplate st;
    static /* synthetic */ Class class$org$antlr$stringtemplate$StringTemplate;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Hashtable;

    public AttributeReflectionController(StringTemplate stringTemplate) {
        this.st = stringTemplate;
    }

    public String toString() {
        this.typesVisited = new HashSet();
        this.output = new StringBuffer(1024);
        this.saveItemIndex();
        this.walkStringTemplate(this.st);
        this.restoreItemIndex();
        this.typesVisited = null;
        return this.output.toString();
    }

    public void walkStringTemplate(StringTemplate stringTemplate) {
        if (this.typesVisited.contains(stringTemplate)) {
            return;
        }
        this.typesVisited.add(stringTemplate);
        this.indent();
        this.output.append("Template ");
        this.output.append(stringTemplate.getName());
        this.output.append(":\n");
        ++this.indentation;
        this.walkAttributes(stringTemplate);
        --this.indentation;
    }

    public void walkAttributes(StringTemplate stringTemplate) {
        if (stringTemplate == null || stringTemplate.getAttributes() == null) {
            return;
        }
        Set set = stringTemplate.getAttributes().keySet();
        this.saveItemIndex();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("attributes")) continue;
            Object v = stringTemplate.getAttributes().get(string);
            this.incItemIndex();
            this.indent();
            this.output.append("Attribute ");
            this.output.append(string);
            this.output.append(" values:\n");
            ++this.indentation;
            this.walkAttributeValues(v);
            --this.indentation;
        }
        this.restoreItemIndex();
    }

    public void walkAttributeValues(Object object) {
        this.saveItemIndex();
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                Class<?> clazz = e.getClass();
                this.incItemIndex();
                this.walkValue(e, clazz);
            }
        } else {
            Class<?> clazz = object.getClass();
            this.incItemIndex();
            this.walkValue(object, clazz);
        }
        this.restoreItemIndex();
    }

    public void walkPropertiesList(Object object, Class clazz) {
        if (this.typesVisited.contains(clazz)) {
            return;
        }
        this.typesVisited.add(clazz);
        this.saveItemIndex();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            String string2 = null;
            if (string.length() > 3 && string.startsWith("get")) {
                string2 = Character.toLowerCase(string.charAt(3)) + string.substring(4, string.length());
            } else {
                if (string.length() <= 2 || !string.startsWith("is")) continue;
                string2 = Character.toLowerCase(string.charAt(2)) + string.substring(3, string.length());
            }
            this.incItemIndex();
            this.indent();
            this.output.append("Property ");
            this.output.append(string2);
            this.output.append(" : ");
            this.output.append(AttributeReflectionController.terseType(method.getReturnType().getName()));
            this.output.append("\n");
            if (method.getReturnType() == (class$org$antlr$stringtemplate$StringTemplate == null ? AttributeReflectionController.class$("org.antlr.stringtemplate.StringTemplate") : class$org$antlr$stringtemplate$StringTemplate)) {
                ++this.indentation;
                this.walkStringTemplate((StringTemplate)this.getRawValue(object, method));
                --this.indentation;
                continue;
            }
            if (ASTExpr.isValidReturnTypeMapInstance(method.getReturnType())) {
                Map map = (Map)this.getRawValue(object, method);
                if (map == null || !ASTExpr.isValidMapInstance(map.getClass())) continue;
                ++this.indentation;
                this.walkValue(map, map.getClass());
                --this.indentation;
                continue;
            }
            if (this.isAtomicType(method.getReturnType())) continue;
            ++this.indentation;
            this.walkValue(null, method.getReturnType());
            --this.indentation;
        }
        this.restoreItemIndex();
    }

    public void walkValue(Object object, Class clazz) {
        if (this.isAtomicType(clazz)) {
            this.walkAtomicType(clazz);
        } else if (clazz == (class$org$antlr$stringtemplate$StringTemplate == null ? (class$org$antlr$stringtemplate$StringTemplate = AttributeReflectionController.class$("org.antlr.stringtemplate.StringTemplate")) : class$org$antlr$stringtemplate$StringTemplate)) {
            this.walkStringTemplate((StringTemplate)object);
        } else if (ASTExpr.isValidMapInstance(clazz)) {
            this.walkMap((Map)object);
        } else {
            this.walkPropertiesList(object, clazz);
        }
    }

    public void walkAtomicType(Class clazz) {
        this.indent();
        this.output.append(AttributeReflectionController.terseType(clazz.getName()));
        this.output.append("\n");
    }

    public void walkMap(Map map) {
        if (map == null) {
            return;
        }
        Set set = map.keySet();
        this.saveItemIndex();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("attributes")) continue;
            Object v = map.get(string);
            this.incItemIndex();
            this.indent();
            this.output.append("Key ");
            this.output.append(string);
            this.output.append(" : ");
            this.output.append(AttributeReflectionController.terseType(v.getClass().getName()));
            this.output.append('\n');
            if (this.isAtomicType(v.getClass())) continue;
            ++this.indentation;
            this.walkValue(v, v.getClass());
            --this.indentation;
        }
        this.restoreItemIndex();
    }

    public boolean isAtomicType(Class clazz) {
        return clazz.getName().startsWith("java.lang.") && clazz != (class$java$util$HashMap == null ? (class$java$util$HashMap = AttributeReflectionController.class$("java.util.HashMap")) : class$java$util$HashMap) && clazz != (class$java$util$Hashtable == null ? (class$java$util$Hashtable = AttributeReflectionController.class$("java.util.Hashtable")) : class$java$util$Hashtable);
    }

    public static String terseType(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("[") >= 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    protected Object getRawValue(Object object, Method method) {
        Object object2 = null;
        try {
            object2 = method.invoke(object, null);
        }
        catch (Exception exception) {
            this.st.error("Can't get property " + method.getName() + " value", exception);
        }
        return object2;
    }

    protected void indent() {
        int n;
        for (n = 1; n <= this.indentation; ++n) {
            this.output.append("    ");
        }
        n = (Integer)this.itemIndexStack.peek();
        if (n > 0) {
            this.output.append(n);
            this.output.append(". ");
        }
    }

    protected void incItemIndex() {
        int n = (Integer)this.itemIndexStack.pop();
        this.itemIndexStack.push(new Integer(n + 1));
    }

    protected void saveItemIndex() {
        this.itemIndexStack.push(new Integer(0));
    }

    protected void restoreItemIndex() {
        this.itemIndexStack.pop();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

