/*
 * Decompiled with CFR 0.152.
 */
package app.boboc.springframework.cloud.github;

import app.boboc.client.github.GitHubContentClient;
import app.boboc.springframework.cloud.github.GitHubCloudProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={GitHubCloudProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lapp/boboc/springframework/cloud/github/GitHubCloudAutoConfiguration;", "", "()V", "log", "Lorg/apache/commons/logging/Log;", "getLog", "()Lorg/apache/commons/logging/Log;", "gitHubContentClient", "Lapp/boboc/client/github/GitHubContentClient;", "properties", "Lapp/boboc/springframework/cloud/github/GitHubCloudProperties;", "spring-cloud-github"})
public class GitHubCloudAutoConfiguration {
    @NotNull
    private final Log log;

    public GitHubCloudAutoConfiguration() {
        Log log = LogFactory.getLog(GitHubCloudAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"getLog(...)");
        this.log = log;
    }

    @NotNull
    public Log getLog() {
        return this.log;
    }

    @ConditionalOnMissingBean
    @Bean
    @NotNull
    public GitHubContentClient gitHubContentClient(@NotNull GitHubCloudProperties properties) {
        GitHubContentClient gitHubContentClient;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.getLog().info((Object)"Create gitHubContentClient bean");
        try {
            gitHubContentClient = new GitHubContentClient(properties.getToken(), properties.getEndPointUri());
        }
        catch (Exception e) {
            this.getLog().warn((Object)"Exception while creating GitHubContentClient", (Throwable)e);
            throw e;
        }
        return gitHubContentClient;
    }
}

