/*
 * Decompiled with CFR 0.152.
 */
package app.boboc.client.github;

import app.boboc.common.Exceptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u001a\u0010\r\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\tJ\f\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\u0010J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0010J\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\tJ\u0012\u0010\u0016\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\tJ\u0012\u0010\u0018\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\tJ\u001a\u0010\u001a\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t\u00a8\u0006 "}, d2={"Lapp/boboc/client/github/GitHubClientUtils;", "", "()V", "add", "Lokhttp3/Headers$Builder;", "header", "Lapp/boboc/client/github/GitHubClientUtils$Header;", "value", "Lapp/boboc/client/github/GitHubClientUtils$AcceptType;", "", "addBranch", "Lokhttp3/HttpUrl;", "branch", "addQueryParameter", "key", "bodyToString", "Lokhttp3/Response;", "isDir", "", "Lokhttp3/Headers;", "replaceOwner", "owner", "replacePath", "path", "replaceRepository", "repository", "replaceSegment", "src", "dst", "AcceptType", "GitHubContentType", "Header", "spring-cloud-github"})
@SourceDebugExtension(value={"SMAP\nGitHubClientUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubClientUtils.kt\napp/boboc/client/github/GitHubClientUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class GitHubClientUtils {
    @NotNull
    public static final GitHubClientUtils INSTANCE = new GitHubClientUtils();

    private GitHubClientUtils() {
    }

    @NotNull
    public final HttpUrl replaceSegment(@NotNull HttpUrl $this$replaceSegment, @NotNull String src, @NotNull String dst) {
        HttpUrl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$replaceSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        HttpUrl.Builder $this$replaceSegment_u24lambda_u241 = builder = $this$replaceSegment.newBuilder();
        boolean bl = false;
        Integer n = $this$replaceSegment.pathSegments().indexOf(src);
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = it != -1 ? n : null;
        if (n2 == null) {
            throw new Exceptions.GitHubClientException("Fail replaceSegment. src: " + src + ", dst: " + dst, null, 2, null);
        }
        int idx = n2;
        $this$replaceSegment_u24lambda_u241.setPathSegment(idx, dst);
        return builder.build();
    }

    @NotNull
    public final HttpUrl addQueryParameter(@NotNull HttpUrl $this$addQueryParameter, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$addQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return $this$addQueryParameter.newBuilder().addQueryParameter(key, value).build();
    }

    @NotNull
    public final HttpUrl addBranch(@NotNull HttpUrl $this$addBranch, @NotNull String branch) {
        Intrinsics.checkNotNullParameter((Object)$this$addBranch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return this.addQueryParameter($this$addBranch, "ref", branch);
    }

    @NotNull
    public final Headers.Builder add(@NotNull Headers.Builder $this$add, @NotNull Header header, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)header), (String)"header");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return $this$add.add(header.getValue(), value);
    }

    @NotNull
    public final Headers.Builder add(@NotNull Headers.Builder $this$add, @NotNull Header header, @NotNull AcceptType value) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)header), (String)"header");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return $this$add.add(header.getValue(), value.getValue());
    }

    @NotNull
    public final HttpUrl replaceOwner(@NotNull HttpUrl $this$replaceOwner, @NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceOwner, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.replaceSegment($this$replaceOwner, "{owner}", owner);
    }

    @NotNull
    public final HttpUrl replaceRepository(@NotNull HttpUrl $this$replaceRepository, @NotNull String repository) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceRepository, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return this.replaceSegment($this$replaceRepository, "{repository}", repository);
    }

    @NotNull
    public final HttpUrl replacePath(@NotNull HttpUrl $this$replacePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$replacePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HttpUrl.Builder builder = $this$replacePath.newBuilder();
        int pathIdx = $this$replacePath.pathSegments().indexOf("{path}");
        builder.removePathSegment(pathIdx);
        builder.addPathSegments(path);
        return builder.build();
    }

    public final boolean isDir(@NotNull Headers $this$isDir) {
        Intrinsics.checkNotNullParameter((Object)$this$isDir, (String)"<this>");
        return $this$isDir.values("Content-Type").contains("application/json");
    }

    public final boolean isDir(@NotNull Response $this$isDir) {
        Intrinsics.checkNotNullParameter((Object)$this$isDir, (String)"<this>");
        return this.isDir($this$isDir.headers());
    }

    @Nullable
    public final String bodyToString(@NotNull Response $this$bodyToString) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$bodyToString, (String)"<this>");
        ResponseBody responseBody = $this$bodyToString.body();
        return responseBody != null && (byArray = responseBody.bytes()) != null ? new String(byArray, Charsets.UTF_8) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lapp/boboc/client/github/GitHubClientUtils$AcceptType;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "OBJECT", "HTML", "RAW", "spring-cloud-github"})
    public static final class AcceptType
    extends Enum<AcceptType> {
        @NotNull
        private final String value;
        public static final /* enum */ AcceptType OBJECT = new AcceptType("application/vnd.github.object+json");
        public static final /* enum */ AcceptType HTML = new AcceptType("application/vnd.github.html+json");
        public static final /* enum */ AcceptType RAW = new AcceptType("application/vnd.github.raw+json");
        private static final /* synthetic */ AcceptType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AcceptType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static AcceptType[] values() {
            return (AcceptType[])$VALUES.clone();
        }

        public static AcceptType valueOf(String value) {
            return Enum.valueOf(AcceptType.class, value);
        }

        @NotNull
        public static EnumEntries<AcceptType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = acceptTypeArray = new AcceptType[]{AcceptType.OBJECT, AcceptType.HTML, AcceptType.RAW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lapp/boboc/client/github/GitHubClientUtils$GitHubContentType;", "", "(Ljava/lang/String;I)V", "FILE", "DIR", "spring-cloud-github"})
    public static final class GitHubContentType
    extends Enum<GitHubContentType> {
        @JsonProperty(value="file")
        public static final /* enum */ GitHubContentType FILE = new GitHubContentType();
        @JsonProperty(value="dir")
        public static final /* enum */ GitHubContentType DIR = new GitHubContentType();
        private static final /* synthetic */ GitHubContentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GitHubContentType[] values() {
            return (GitHubContentType[])$VALUES.clone();
        }

        public static GitHubContentType valueOf(String value) {
            return Enum.valueOf(GitHubContentType.class, value);
        }

        @NotNull
        public static EnumEntries<GitHubContentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gitHubContentTypeArray = new GitHubContentType[]{GitHubContentType.FILE, GitHubContentType.DIR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lapp/boboc/client/github/GitHubClientUtils$Header;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "AUTHORIZATION", "ACCEPT", "GITHUB_VERSION", "spring-cloud-github"})
    public static final class Header
    extends Enum<Header> {
        @NotNull
        private final String value;
        public static final /* enum */ Header AUTHORIZATION = new Header("Authorization");
        public static final /* enum */ Header ACCEPT = new Header("Accept");
        public static final /* enum */ Header GITHUB_VERSION = new Header("X-GitHub-Api-Version");
        private static final /* synthetic */ Header[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Header(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static Header[] values() {
            return (Header[])$VALUES.clone();
        }

        public static Header valueOf(String value) {
            return Enum.valueOf(Header.class, value);
        }

        @NotNull
        public static EnumEntries<Header> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = headerArray = new Header[]{Header.AUTHORIZATION, Header.ACCEPT, Header.GITHUB_VERSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

