/*
 * Decompiled with CFR 0.152.
 */
package app.boboc.springframework.cloud.github;

import app.boboc.client.github.GitHubContentClient;
import app.boboc.springframework.cloud.github.GitHubCloudConfigDataResource;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lapp/boboc/springframework/cloud/github/GitHubCloudConfigDataLoader;", "Lorg/springframework/boot/context/config/ConfigDataLoader;", "Lapp/boboc/springframework/cloud/github/GitHubCloudConfigDataResource;", "()V", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/commons/logging/Log;", "load", "Lorg/springframework/boot/context/config/ConfigData;", "context", "Lorg/springframework/boot/context/config/ConfigDataLoaderContext;", "resource", "spring-cloud-github"})
public final class GitHubCloudConfigDataLoader
implements ConfigDataLoader<GitHubCloudConfigDataResource> {
    private final Log log = LogFactory.getLog(GitHubCloudConfigDataLoader.class);

    public final Log getLog() {
        return this.log;
    }

    @NotNull
    public ConfigData load(@NotNull ConfigDataLoaderContext context, @NotNull GitHubCloudConfigDataResource resource) {
        ConfigData configData;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)resource), (String)"resource");
        try {
            this.log.info((Object)"Loading GitHub config data");
            GitHubContentClient ghClient = (GitHubContentClient)context.getBootstrapContext().get(GitHubContentClient.class);
            Intrinsics.checkNotNull((Object)ghClient);
            configData = new ConfigData((Collection)CollectionsKt.listOf((Object)((Object)resource.getPropertySource(ghClient))), new ConfigData.Option[0]);
        }
        catch (Exception e) {
            this.log.warn((Object)"Could not load GitHub config data", (Throwable)e);
            throw e;
        }
        return configData;
    }
}

