/*
 * Decompiled with CFR 0.152.
 */
package app.boboc.springframework.cloud.github;

import app.boboc.client.github.GitHubContentClient;
import app.boboc.springframework.cloud.github.GitHubCloudConfigDataResource;
import app.boboc.springframework.cloud.github.GitHubCloudProperties;
import app.boboc.springframework.cloud.github.ResolvedContexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.apache.commons.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016*\u00020\u0018H\u0002J\f\u0010\u001c\u001a\u00020\u000e*\u00020\u001dH\u0002J1\u0010\u001e\u001a\u00020\u001f\"\b\b\u0000\u0010 *\u00020!*\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#2\u0006\u0010\u0019\u001a\u0002H H\u0002\u00a2\u0006\u0002\u0010$R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lapp/boboc/springframework/cloud/github/GitHubCloudConfigDataLocationResolver;", "Lorg/springframework/boot/context/config/ConfigDataLocationResolver;", "Lapp/boboc/springframework/cloud/github/GitHubCloudConfigDataResource;", "deferredLogFactory", "Lorg/springframework/boot/logging/DeferredLogFactory;", "(Lorg/springframework/boot/logging/DeferredLogFactory;)V", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/commons/logging/Log;", "createGitHubContentClient", "Lapp/boboc/client/github/GitHubContentClient;", "prop", "Lapp/boboc/springframework/cloud/github/GitHubCloudProperties;", "isResolvable", "", "context", "Lorg/springframework/boot/context/config/ConfigDataLocationResolverContext;", "location", "Lorg/springframework/boot/context/config/ConfigDataLocation;", "resolve", "", "resolveContexts", "Lapp/boboc/springframework/cloud/github/ResolvedContexts;", "value", "", "buildResources", "loadProperties", "Lorg/springframework/boot/context/properties/bind/Binder;", "registerBean", "", "T", "", "clazz", "Lkotlin/reflect/KClass;", "(Lorg/springframework/boot/context/config/ConfigDataLocationResolverContext;Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "Companion", "spring-cloud-github"})
@SourceDebugExtension(value={"SMAP\nGitHubCloudConfigDataLocationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubCloudConfigDataLocationResolver.kt\napp/boboc/springframework/cloud/github/GitHubCloudConfigDataLocationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1549#2:82\n1620#2,3:83\n*S KotlinDebug\n*F\n+ 1 GitHubCloudConfigDataLocationResolver.kt\napp/boboc/springframework/cloud/github/GitHubCloudConfigDataLocationResolver\n*L\n56#1:82\n56#1:83,3\n*E\n"})
public final class GitHubCloudConfigDataLocationResolver
implements ConfigDataLocationResolver<GitHubCloudConfigDataResource> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Log log;
    @NotNull
    public static final String PREFIX = "github-cloud/";

    public GitHubCloudConfigDataLocationResolver(@NotNull DeferredLogFactory deferredLogFactory) {
        Intrinsics.checkNotNullParameter((Object)deferredLogFactory, (String)"deferredLogFactory");
        this.log = deferredLogFactory.getLog(GitHubCloudConfigDataLocationResolver.class);
    }

    public final Log getLog() {
        return this.log;
    }

    public boolean isResolvable(@NotNull ConfigDataLocationResolverContext context, @NotNull ConfigDataLocation location) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return location.hasPrefix(PREFIX);
    }

    @NotNull
    public List<GitHubCloudConfigDataResource> resolve(@NotNull ConfigDataLocationResolverContext context, @NotNull ConfigDataLocation location) {
        List<GitHubCloudConfigDataResource> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            this.log.info((Object)("Resolving - " + location.getValue()));
            Binder binder = context.getBinder();
            Intrinsics.checkNotNullExpressionValue((Object)binder, (String)"getBinder(...)");
            GitHubCloudProperties properties = this.loadProperties(binder);
            this.registerBean(context, Reflection.getOrCreateKotlinClass(GitHubCloudProperties.class), properties);
            this.registerBean(context, Reflection.getOrCreateKotlinClass(GitHubContentClient.class), this.createGitHubContentClient(properties));
            String string = location.getNonPrefixedValue(PREFIX);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNonPrefixedValue(...)");
            list = this.buildResources(this.resolveContexts(string));
        }
        catch (Exception e) {
            this.log.info((Object)("Fail to resolve. cause of - [" + e.getMessage() + "]"));
            throw e;
        }
        return list;
    }

    private final ResolvedContexts resolveContexts(String value) {
        String[] stringArray = new String[]{":"};
        List list = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String targets = (String)list.get(0);
        String pathsString = (String)list.get(1);
        String[] stringArray2 = new String[]{"/"};
        List seperatedTargets = StringsKt.split$default((CharSequence)targets, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        stringArray2 = new String[]{";"};
        return new ResolvedContexts((String)seperatedTargets.get(0), (String)seperatedTargets.get(1), (String)CollectionsKt.getOrNull((List)seperatedTargets, (int)2), StringsKt.split$default((CharSequence)pathsString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<GitHubCloudConfigDataResource> buildResources(ResolvedContexts $this$buildResources) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$buildResources.getPaths();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void path;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GitHubCloudConfigDataResource($this$buildResources.getOwner(), $this$buildResources.getRepository(), $this$buildResources.getRef(), (String)path));
        }
        return (List)destination$iv$iv;
    }

    private final GitHubCloudProperties loadProperties(Binder $this$loadProperties) {
        Object object = $this$loadProperties.bind("github.cloud", Bindable.of(GitHubCloudProperties.class)).orElseGet(GitHubCloudConfigDataLocationResolver::loadProperties$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"orElseGet(...)");
        return (GitHubCloudProperties)object;
    }

    private final <T> void registerBean(ConfigDataLocationResolverContext $this$registerBean, KClass<T> clazz, T value) {
        $this$registerBean.getBootstrapContext().registerIfAbsent(JvmClassMappingKt.getJavaClass(clazz), BootstrapRegistry.InstanceSupplier.of(value));
    }

    private final GitHubContentClient createGitHubContentClient(GitHubCloudProperties prop) {
        return new GitHubContentClient(prop.getToken(), prop.getEndPointUri());
    }

    private static final GitHubCloudProperties loadProperties$lambda$1() {
        return new GitHubCloudProperties(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/boboc/springframework/cloud/github/GitHubCloudConfigDataLocationResolver$Companion;", "", "()V", "PREFIX", "", "spring-cloud-github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

