/*
 * Decompiled with CFR 0.152.
 */
package app.boboc.client.github;

import app.boboc.client.github.GitHubClientUtils;
import app.boboc.client.github.GitHubDirectoryContent;
import app.boboc.common.Exceptions;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003J2\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003J*\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0016\u0010\u001a\u001a\u00020\u000b*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002J$\u0010\u001b\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/boboc/client/github/GitHubContentClient;", "", "token", "", "uri", "(Ljava/lang/String;Ljava/lang/String;)V", "header", "Lokhttp3/Headers;", "httpClient", "Lokhttp3/OkHttpClient;", "url", "Lokhttp3/HttpUrl;", "contentRequest", "Lokhttp3/Request;", "owner", "repository", "path", "branch", "getContentResponse", "Lokhttp3/Response;", "getDirectoryContents", "", "Lapp/boboc/client/github/GitHubDirectoryContent;", "getFileContent", "sendRequest", "req", "addBranch", "replaceSegments", "Companion", "spring-cloud-github"})
public final class GitHubContentClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpUrl url;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final Headers header;
    @NotNull
    public static final String GITHUB_API_VERSION = "2022-11-28";
    @NotNull
    public static final String DEFAULT_BASE_URL = "https://api.github.com";
    @NotNull
    public static final String CONTENT_SEGMENT = "repos/{owner}/{repository}/contents/{path}";
    @NotNull
    private static final ObjectMapper mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)new YAMLFactory()));
    @NotNull
    private static final TypeReference<List<GitHubDirectoryContent>> DIRECTORY_TYPE_REFERENCE = (TypeReference)new TypeReference<List<? extends GitHubDirectoryContent>>(){};

    public GitHubContentClient(@NotNull String token, @Nullable String uri) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = uri;
        if (string == null) {
            string = DEFAULT_BASE_URL;
        }
        HttpUrl httpUrl = HttpUrl.Companion.parse(string + "/repos/{owner}/{repository}/contents/{path}");
        Intrinsics.checkNotNull((Object)httpUrl);
        this.url = httpUrl;
        this.httpClient = new OkHttpClient().newBuilder().build();
        this.header = GitHubClientUtils.INSTANCE.add(GitHubClientUtils.INSTANCE.add(GitHubClientUtils.INSTANCE.add(new Headers.Builder(), GitHubClientUtils.Header.AUTHORIZATION, "Bearer " + token), GitHubClientUtils.Header.ACCEPT, GitHubClientUtils.AcceptType.RAW), GitHubClientUtils.Header.GITHUB_VERSION, GITHUB_API_VERSION).build();
    }

    private final Response sendRequest(Request req) {
        return this.httpClient.newCall(req).execute();
    }

    private final Request contentRequest(String owner, String repository, String path, String branch) {
        return new Request.Builder().url(this.addBranch(this.replaceSegments(this.url, owner, repository, path), branch)).headers(this.header).build();
    }

    static /* synthetic */ Request contentRequest$default(GitHubContentClient gitHubContentClient, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        return gitHubContentClient.contentRequest(string, string2, string3, string4);
    }

    @NotNull
    public final Response getContentResponse(@NotNull String owner, @NotNull String repository, @NotNull String path, @Nullable String branch) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Response it = response = this.sendRequest(this.contentRequest(owner, repository, path, branch));
        boolean bl = false;
        if (!it.isSuccessful()) {
            String string = GitHubClientUtils.INSTANCE.bodyToString(it);
            if (string == null) {
                string = it.message();
            }
            throw new Exceptions.GitHubClientException(string, null, 2, null);
        }
        if (it.body() == null) {
            throw new Exceptions.GitHubClientException("Body cannot be null", null, 2, null);
        }
        return response;
    }

    public static /* synthetic */ Response getContentResponse$default(GitHubContentClient gitHubContentClient, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        return gitHubContentClient.getContentResponse(string, string2, string3, string4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFileContent(@NotNull String owner, @NotNull String repository, @NotNull String path, @Nullable String branch) {
        void it;
        Response response;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Response response2 = response = this.getContentResponse(owner, repository, path, branch);
        GitHubClientUtils gitHubClientUtils = GitHubClientUtils.INSTANCE;
        boolean bl = false;
        if (GitHubClientUtils.INSTANCE.isDir((Response)it)) {
            throw new Exceptions.GitHubClientException("Path should be a file.", null, 2, null);
        }
        String string = gitHubClientUtils.bodyToString(response);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static /* synthetic */ String getFileContent$default(GitHubContentClient gitHubContentClient, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        return gitHubContentClient.getFileContent(string, string2, string3, string4);
    }

    @Nullable
    public final List<GitHubDirectoryContent> getDirectoryContents(@NotNull String owner, @NotNull String repository, @NotNull String path, @Nullable String branch) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Response it = response = this.getContentResponse(owner, repository, path, branch);
        boolean bl = false;
        if (!GitHubClientUtils.INSTANCE.isDir(it)) {
            throw new Exceptions.GitHubClientException("Path should be a directory.", null, 2, null);
        }
        Response $this$getDirectoryContents_u24lambda_u243 = response;
        boolean bl2 = false;
        ResponseBody responseBody = $this$getDirectoryContents_u24lambda_u243.body();
        Intrinsics.checkNotNull((Object)responseBody);
        return (List)mapper.readValue(responseBody.bytes(), DIRECTORY_TYPE_REFERENCE);
    }

    public static /* synthetic */ List getDirectoryContents$default(GitHubContentClient gitHubContentClient, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        return gitHubContentClient.getDirectoryContents(string, string2, string3, string4);
    }

    private final HttpUrl replaceSegments(HttpUrl $this$replaceSegments, String owner, String repository, String path) {
        return GitHubClientUtils.INSTANCE.replacePath(GitHubClientUtils.INSTANCE.replaceRepository(GitHubClientUtils.INSTANCE.replaceOwner($this$replaceSegments, owner), repository), path);
    }

    private final HttpUrl addBranch(HttpUrl $this$addBranch, String branch) {
        return branch != null ? GitHubClientUtils.INSTANCE.addQueryParameter($this$addBranch, "refs", branch) : $this$addBranch;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lapp/boboc/client/github/GitHubContentClient$Companion;", "", "()V", "CONTENT_SEGMENT", "", "DEFAULT_BASE_URL", "DIRECTORY_TYPE_REFERENCE", "Lcom/fasterxml/jackson/core/type/TypeReference;", "", "Lapp/boboc/client/github/GitHubDirectoryContent;", "getDIRECTORY_TYPE_REFERENCE", "()Lcom/fasterxml/jackson/core/type/TypeReference;", "GITHUB_API_VERSION", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "spring-cloud-github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        @NotNull
        public final TypeReference<List<GitHubDirectoryContent>> getDIRECTORY_TYPE_REFERENCE() {
            return DIRECTORY_TYPE_REFERENCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

