/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.getters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryField;
import java.lang.reflect.Method;
import java.util.List;

public class MetaFieldMapper<X>
implements FieldMapper<X> {
    private final String metaFieldName;
    private final Class<X> fieldType;
    private final ObjectMapper mapper;

    public MetaFieldMapper(String metaFieldName, Class<X> fieldType, Method method, ObjectMapper mapper) {
        this.metaFieldName = metaFieldName;
        this.fieldType = fieldType;
        this.mapper = mapper;
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        try {
            JsonNode fieldNode = current.get(this.metaFieldName);
            return (X)this.mapper.convertValue((Object)fieldNode, this.fieldType);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error deserializing %s".formatted(this.metaFieldName), t);
        }
    }

    @Override
    public List<QueryField> getQueryFields() {
        return List.of();
    }
}

