/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.mappers.objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import gg.xp.xivapi.annotations.NullIfZero;
import gg.xp.xivapi.annotations.XivApiMetaField;
import gg.xp.xivapi.annotations.XivApiRaw;
import gg.xp.xivapi.annotations.XivApiThis;
import gg.xp.xivapi.annotations.XivApiTransientField;
import gg.xp.xivapi.clienttypes.XivApiBase;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import gg.xp.xivapi.exceptions.XivApiException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.QueryField;
import gg.xp.xivapi.mappers.getters.MetaFieldMapper;
import gg.xp.xivapi.mappers.getters.NormalFieldMapper;
import gg.xp.xivapi.mappers.getters.RawFieldMapper;
import gg.xp.xivapi.mappers.getters.RawTransientFieldMapper;
import gg.xp.xivapi.mappers.getters.ThisFieldMapper;
import gg.xp.xivapi.mappers.getters.TransientFieldMapper;
import gg.xp.xivapi.mappers.objects.ObjectInvocationHandler;
import gg.xp.xivapi.mappers.util.MappingUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFieldMapper<X>
implements FieldMapper<X> {
    private static final Logger log = LoggerFactory.getLogger(ObjectFieldMapper.class);
    private final Map<Method, FieldMapper<?>> methodFieldMap = new LinkedHashMap();
    private final Class<X> objectType;
    private final Method pkMethod;
    private final Method ridMethod;
    private final Method svMethod;
    private final Method tsMethod;

    public ObjectFieldMapper(Class<X> cls, ObjectMapper mapper) {
        this.objectType = cls;
        try {
            this.pkMethod = cls.getMethod("getPrimaryKey", new Class[0]);
            this.ridMethod = cls.getMethod("getRowId", new Class[0]);
            this.svMethod = XivApiBase.class.getMethod("getSchemaVersion", new Class[0]);
            this.tsMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new XivApiException(e);
        }
        for (Method method : cls.getMethods()) {
            if (method.getDeclaringClass().isAssignableFrom(XivApiObject.class) || method.isDefault()) continue;
            Class<?> returnType = method.getReturnType();
            XivApiThis thisAnn = method.getAnnotation(XivApiThis.class);
            XivApiMetaField metaFieldAnn = method.getAnnotation(XivApiMetaField.class);
            XivApiTransientField transientFieldAnn = method.getAnnotation(XivApiTransientField.class);
            String fieldName = MappingUtils.getFieldName(method);
            FieldMapper<Object> fieldMapper = thisAnn != null ? new ThisFieldMapper(transientFieldAnn != null, returnType, method, mapper) : (metaFieldAnn != null ? new MetaFieldMapper(fieldName, returnType, method, mapper) : (transientFieldAnn != null ? (method.isAnnotationPresent(XivApiRaw.class) ? new RawTransientFieldMapper(fieldName, returnType, method, mapper) : new TransientFieldMapper(fieldName, returnType, method, mapper)) : (method.isAnnotationPresent(XivApiRaw.class) ? new RawFieldMapper(fieldName, returnType, method, mapper) : new NormalFieldMapper(fieldName, returnType, method, mapper))));
            this.methodFieldMap.put(method, fieldMapper);
        }
    }

    @Override
    public X getValue(JsonNode current, XivApiContext context) {
        LinkedHashMap<Method, Object> methodValueMap = new LinkedHashMap<Method, Object>();
        try {
            int rowId;
            int primaryKey;
            boolean isNested;
            boolean bl = isNested = current != context.rootNode();
            if (isNested) {
                boolean zeroValue;
                boolean bl2 = zeroValue = current.get("value").asInt() == 0;
                if (zeroValue && (current.get("row_id") == null || current.get("fields") == null || current.get("fields").isEmpty())) {
                    return null;
                }
                if (zeroValue && this.objectType.isAnnotationPresent(NullIfZero.class)) {
                    return null;
                }
                primaryKey = current.get("value").asInt();
                rowId = current.get("row_id").asInt();
            } else {
                rowId = primaryKey = current.get("row_id").asInt();
            }
            methodValueMap.put(this.pkMethod, primaryKey);
            methodValueMap.put(this.ridMethod, rowId);
            methodValueMap.put(this.svMethod, context.schemaVersion());
            methodValueMap.put(this.tsMethod, "%s(%s)".formatted(this.objectType.getSimpleName(), rowId));
            this.methodFieldMap.forEach((method, fieldMapper) -> {
                Object value = fieldMapper.getValue(current, context);
                methodValueMap.put((Method)method, value);
            });
        }
        catch (Throwable t) {
            throw new XivApiDeserializationException("Error deserializing %s from '%s'".formatted(this.objectType, current), t);
        }
        boolean strict = context.settings().isStrict();
        return (X)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.objectType}, (InvocationHandler)new ObjectInvocationHandler(methodValueMap, strict));
    }

    @Override
    public List<QueryField> getQueryFields() {
        if (this.methodFieldMap.values().stream().flatMap(it -> it.getQueryFields().stream()).anyMatch(QueryField::isAll)) {
            return List.of();
        }
        return this.methodFieldMap.values().stream().flatMap(fm -> fm.getQueryFields().stream()).toList();
    }
}

