/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.pagination;

import com.fasterxml.jackson.databind.JsonNode;
import gg.xp.xivapi.XivApiClient;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.clienttypes.XivApiSchemaVersion;
import gg.xp.xivapi.exceptions.XivApiDeserializationException;
import gg.xp.xivapi.impl.XivApiContext;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.mappers.util.MappingUtils;
import gg.xp.xivapi.pagination.BufferedIterator;
import gg.xp.xivapi.pagination.XivApiListPaginator;
import gg.xp.xivapi.pagination.XivApiSearchPaginator;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.IteratorUtils;

public abstract sealed class XivApiPaginator<X extends XivApiObject>
implements Iterator<X>
permits XivApiListPaginator, XivApiSearchPaginator {
    private final XivApiClient client;
    protected final URI originalUri;
    private final BiPredicate<Integer, X> stopCondition;
    private final FieldMapper<X> mapper;
    protected final int perPageItemCount;
    protected XivApiPage currentPage;
    private int globalBaseIndex;
    private boolean hasHitStopCondition;

    protected XivApiPaginator(XivApiClient client, URI originalUri, BiPredicate<Integer, X> stopCondition, FieldMapper<X> mapper, int perPageItemCount, JsonNode firstResponse) {
        this.client = client;
        this.originalUri = originalUri;
        this.stopCondition = stopCondition;
        this.mapper = mapper;
        this.perPageItemCount = perPageItemCount;
        this.currentPage = new XivApiPage(firstResponse);
    }

    protected abstract URI getNextPageUri();

    private void nextPage() {
        this.globalBaseIndex += this.currentPage.size();
        URI newURI = this.getNextPageUri();
        JsonNode newRoot = this.client.sendGET(newURI);
        this.currentPage = new XivApiPage(newRoot);
    }

    @Override
    public boolean hasNext() {
        if (!this.currentPage.hasAnyValues()) {
            return false;
        }
        if (this.hasHitStopCondition) {
            return false;
        }
        if (!this.currentPage.hasNext()) {
            if (!this.hasMorePages()) {
                return false;
            }
            this.nextPage();
        }
        return this.currentPage.hasNext();
    }

    protected boolean hasMorePages() {
        return this.currentPage.size() >= this.perPageItemCount;
    }

    @Override
    public X next() {
        if (!this.currentPage.hasNext()) {
            throw new NoSuchElementException("Current page has no more values");
        }
        return (X)this.currentPage.next();
    }

    protected abstract JsonNode getResultsNode(JsonNode var1);

    public List<X> toList() {
        return IteratorUtils.toList((Iterator)this);
    }

    public Stream<X> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
    }

    public Iterator<X> toBufferedIterator(int bufferSize) {
        return new BufferedIterator(this, bufferSize);
    }

    public Stream<X> toBufferedStream(int bufferSize) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.toBufferedIterator(bufferSize), 16), false);
    }

    protected class XivApiPage
    implements Iterator<X> {
        protected final List<X> values;
        protected int index;
        protected JsonNode rootNode;

        XivApiPage(JsonNode root) {
            this.rootNode = root;
            JsonNode rows = XivApiPaginator.this.getResultsNode(this.rootNode);
            if (rows == null) {
                throw new XivApiDeserializationException("Missing main results field in response");
            }
            XivApiSchemaVersion sv = MappingUtils.makeSchemaVersion(root.get("schema").textValue());
            Iterable iter = () -> ((JsonNode)rows).elements();
            this.values = StreamSupport.stream(iter.spliterator(), false).map(node -> {
                XivApiContext context = new XivApiContext((JsonNode)node, XivApiPaginator.this.client.getSettings(), sv);
                return (XivApiObject)XivApiPaginator.this.mapper.getValue((JsonNode)node, context);
            }).toList();
        }

        @Override
        public boolean hasNext() {
            if (this.values.isEmpty()) {
                return false;
            }
            if (this.index >= this.values.size()) {
                return false;
            }
            XivApiObject peek = (XivApiObject)this.values.get(this.index);
            boolean fullStop = XivApiPaginator.this.stopCondition.test(this.index + XivApiPaginator.this.globalBaseIndex, peek);
            if (fullStop) {
                XivApiPaginator.this.hasHitStopCondition = true;
                return false;
            }
            return true;
        }

        boolean hasAnyValues() {
            return !this.values.isEmpty();
        }

        @Override
        public X next() {
            XivApiObject out;
            try {
                out = (XivApiObject)this.values.get(this.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException(e);
            }
            ++this.index;
            return out;
        }

        public int size() {
            return this.values.size();
        }
    }
}

