/*
 * Decompiled with CFR 0.152.
 */
package gg.xp.xivapi.pagination;

import com.fasterxml.jackson.databind.JsonNode;
import gg.xp.xivapi.XivApiClient;
import gg.xp.xivapi.clienttypes.XivApiObject;
import gg.xp.xivapi.mappers.FieldMapper;
import gg.xp.xivapi.pagination.XivApiPaginator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiPredicate;
import org.apache.hc.core5.net.URIBuilder;

public final class XivApiSearchPaginator<X extends XivApiObject>
extends XivApiPaginator<X> {
    public XivApiSearchPaginator(XivApiClient client, JsonNode firstResponse, URI originalUri, BiPredicate<Integer, X> stopCondition, FieldMapper<X> mapper, int perPageItemCount) {
        super(client, originalUri, stopCondition, mapper, perPageItemCount, firstResponse);
    }

    @Override
    protected URI getNextPageUri() {
        String cursor = this.currentPage.rootNode.get("next").textValue();
        try {
            return new URIBuilder(this.originalUri).setParameter("cursor", cursor).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected JsonNode getResultsNode(JsonNode rootNode) {
        return rootNode.get("results");
    }

    @Override
    protected boolean hasMorePages() {
        return this.currentPage.rootNode.get("next") != null;
    }
}

