/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder;

import ca.krasnay.sqlbuilder.AbstractSqlBuilder;
import ca.krasnay.sqlbuilder.ParameterizedPreparedStatementCreator;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.PreparedStatementCreator;

public abstract class AbstractSqlCreator
implements PreparedStatementCreator,
Serializable {
    private int paramIndex;
    private ParameterizedPreparedStatementCreator ppsc = new ParameterizedPreparedStatementCreator();

    public AbstractSqlCreator() {
    }

    public AbstractSqlCreator(AbstractSqlCreator other) {
        this.paramIndex = other.paramIndex;
        this.ppsc = other.ppsc.clone();
    }

    public String allocateParameter() {
        return "param" + this.paramIndex++;
    }

    public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
        return this.ppsc.setSql(this.getBuilder().toString()).createPreparedStatement(conn);
    }

    protected abstract AbstractSqlBuilder getBuilder();

    protected ParameterizedPreparedStatementCreator getPreparedStatementCreator() {
        return this.ppsc;
    }

    public AbstractSqlCreator setParameter(String name, Object value) {
        this.ppsc.setParameter(name, value);
        return this;
    }
}

