/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import ca.krasnay.sqlbuilder.orm.Converter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;

public final class DateTimeConverter
implements Converter<DateTime> {
    private static final DateTimeConverter INSTANCE = new DateTimeConverter();

    public static DateTimeConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public Object convertFieldValueToColumn(DateTime fieldValue) {
        return fieldValue != null ? new Timestamp(fieldValue.getMillis()) : null;
    }

    @Override
    public DateTime getFieldValueFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnLabel);
        if (timestamp == null) {
            return null;
        }
        return new DateTime((Object)timestamp);
    }
}

