/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import ca.krasnay.sqlbuilder.orm.Converter;
import ca.krasnay.sqlbuilder.orm.ConverterFactory;
import ca.krasnay.sqlbuilder.orm.DefaultConverter;
import ca.krasnay.sqlbuilder.orm.EnumStringConverter;
import ca.krasnay.sqlbuilder.orm.LocaleConverter;
import ca.krasnay.sqlbuilder.orm.StringConverter;
import ca.krasnay.sqlbuilder.orm.TimestampConverter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

public class DefaultConverterFactory
implements ConverterFactory {
    @Override
    public Converter<?> getConverter(Class<?> fieldClass) {
        if (fieldClass == String.class) {
            return StringConverter.getInstance();
        }
        if (fieldClass == Date.class || fieldClass == Timestamp.class) {
            return TimestampConverter.getInstance();
        }
        if (Enum.class.isAssignableFrom(fieldClass)) {
            EnumStringConverter<?> converter = EnumStringConverter.create(fieldClass);
            return converter;
        }
        if (fieldClass == Locale.class) {
            return LocaleConverter.getInstance();
        }
        return DefaultConverter.getInstance();
    }
}

