/*
 * Decompiled with CFR 0.152.
 */
package ca.krasnay.sqlbuilder.orm;

import java.util.ArrayList;
import java.util.List;

public class StringListFlattener {
    private boolean convertEmptyToNull = false;
    private char separator;
    private char escapeChar;

    public StringListFlattener(char separator, char escapeChar) {
        this.separator = separator;
        this.escapeChar = escapeChar;
    }

    public StringListFlattener(char separator) {
        this(separator, '\\');
    }

    public StringListFlattener() {
        this(',', '\\');
    }

    public List<String> split(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s == null) {
            return result;
        }
        boolean seenEscape = false;
        boolean seenSeparator = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            seenSeparator = false;
            char c = s.charAt(i);
            if (seenEscape) {
                if (c == this.escapeChar || c == this.separator) {
                    sb.append(c);
                } else {
                    sb.append(this.escapeChar).append(c);
                }
                seenEscape = false;
                continue;
            }
            if (c == this.escapeChar) {
                seenEscape = true;
                continue;
            }
            if (c == this.separator) {
                if (sb.length() == 0 && this.convertEmptyToNull) {
                    result.add(null);
                } else {
                    result.add(sb.toString());
                }
                sb.setLength(0);
                seenSeparator = true;
                continue;
            }
            sb.append(c);
        }
        if (seenEscape) {
            sb.append(this.escapeChar);
        }
        if (sb.length() > 0 || seenSeparator) {
            if (sb.length() == 0 && this.convertEmptyToNull) {
                result.add(null);
            } else {
                result.add(sb.toString());
            }
        }
        return result;
    }

    public String join(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (s == null) {
                if (this.convertEmptyToNull) {
                    s = "";
                } else {
                    throw new IllegalArgumentException("StringListFlattener does not support null strings in the list. Consider calling setConvertEmptyToNull(true).");
                }
            }
            if (!first) {
                sb.append(this.separator);
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == this.escapeChar || c == this.separator) {
                    sb.append(this.escapeChar);
                }
                sb.append(c);
            }
            first = false;
        }
        return sb.toString();
    }

    public StringListFlattener setConvertEmptyToNull(boolean convertEmptyToNull) {
        this.convertEmptyToNull = convertEmptyToNull;
        return this;
    }
}

