/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.dirq;

import ch.cern.dirq.QueueException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class Queue
implements Iterable<String> {
    private static final int defaultMaxTemp = 300;
    private static final int defaultMaxLock = 600;
    public static final Pattern DirectoryRegexp = Pattern.compile("[0-9a-f]{8}");
    public static final Pattern ElementRegexp = Pattern.compile("[0-9a-f]{14}");
    protected String id = null;
    protected String path = null;

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public abstract String add(String var1) throws QueueException;

    public abstract String add(byte[] var1) throws QueueException;

    public abstract String addPath(String var1) throws QueueException;

    public abstract String get(String var1) throws Exception;

    public abstract byte[] getAsByteArray(String var1) throws Exception;

    public abstract String getPath(String var1) throws Exception;

    public boolean lock(String name) throws Exception {
        return this.lock(name, true);
    }

    public abstract boolean lock(String var1, boolean var2) throws Exception;

    public boolean unlock(String name) throws Exception {
        return this.unlock(name, false);
    }

    public abstract boolean unlock(String var1, boolean var2) throws Exception;

    public abstract void remove(String var1) throws Exception;

    public abstract int count();

    public void purge() throws QueueException {
        this.purge(300, 600);
    }

    public void purge(Map<String, Integer> options) throws QueueException {
        int maxLock = options.get("maxLock") == null ? 600 : options.get("maxLock");
        int maxTemp = options.get("maxTemp") == null ? 300 : options.get("maxTemp");
        this.purge(maxTemp, maxLock);
    }

    public void purge(int maxLock) throws QueueException {
        this.purge(300, maxLock);
    }

    public abstract void purge(int var1, int var2) throws QueueException;

    @Override
    public abstract Iterator<String> iterator();
}

