/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.dirq;

import ch.cern.dirq.LEE;
import ch.cern.dirq.Queue;
import ch.cern.dirq.QueueException;
import ch.cern.dirq.QueueIterator;
import ch.cern.mig.posix.BasePosix;
import ch.cern.mig.posix.FileStat;
import ch.cern.mig.posix.Posix;
import ch.cern.mig.utils.FileUtils;
import ch.cern.mig.utils.RegExpFilenameFilter;
import com.sun.jna.LastErrorException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public class QueueSimple
extends Queue {
    private static final BasePosix posix = Posix.posix;
    private static boolean WARN = false;
    private static final String UPID = String.format("%01x", posix.getpid() % 16);
    public static final String TEMPORARY_SUFFIX = ".tmp";
    public static final String LOCKED_SUFFIX = ".lck";
    private static final int default_umask = posix.umask();
    private static final int default_granularity = 60;
    private int umask;
    private int granularity;

    public int getGranularity() {
        return this.granularity;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public QueueSimple(String path) throws QueueException {
        this(path, default_umask, 60);
    }

    public QueueSimple(String path, int umask) throws QueueException {
        this(path, umask, 60);
    }

    public QueueSimple(String path, int umask, int granularity) throws QueueException {
        this.path = path;
        this.umask = umask;
        this.granularity = granularity;
        File dir = new File(path);
        if (dir.exists() && !dir.isDirectory()) {
            throw new QueueException("not a directory: " + path);
        }
        if (umask >= 512) {
            throw new QueueException("invalid umask: " + umask);
        }
        String tmpPath = "";
        for (String subDir : dir.getPath().split("/+")) {
            if (new File(tmpPath = tmpPath + subDir + "/").exists()) continue;
            QueueSimple.specialMkdir(tmpPath, umask);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.id = path;
        } else {
            FileStat stat = posix.stat(path);
            this.id = "" + stat.dev() + ":" + stat.ino();
        }
    }

    protected String _name() {
        return String.format("%013x%s", System.nanoTime() / 1000L, UPID);
    }

    private static boolean specialMkdir(String path) throws QueueException {
        return QueueSimple.specialMkdir(path, posix.umask());
    }

    private static boolean specialMkdir(String path, int umask) throws QueueException {
        try {
            posix.mkdir(path, 511 - umask);
        }
        catch (LastErrorException e) {
            if (LEE.getErrorCode(e) == 17 && !new File(path).isFile()) {
                return false;
            }
            if (LEE.getErrorCode(e) == 21) {
                return false;
            }
            throw new QueueException(String.format("cannot mkdir(%s): %s", path, e.getMessage()));
        }
        return true;
    }

    private boolean specialRmdir(String path) throws QueueException {
        try {
            posix.rmdir(path);
        }
        catch (LastErrorException e) {
            if (LEE.getErrorCode(e) != 2) {
                throw new QueueException(String.format("cannot rmdir(%s): %s", path, e.getMessage()));
            }
            return false;
        }
        return true;
    }

    @Override
    public String add(byte[] data) throws QueueException {
        String dir = this._addDir();
        File tmp = this._addData(dir, data);
        return this._addPath(tmp, dir);
    }

    @Override
    public String add(String data) throws QueueException {
        String dir = this._addDir();
        File tmp = this._addData(dir, data);
        return this._addPath(tmp, dir);
    }

    private String _addPath(File tmp, String dir) throws QueueException {
        String name;
        while (true) {
            name = this._name();
            File newFile = new File(this.path + File.separator + dir + File.separator + name);
            try {
                posix.link(tmp.getPath(), newFile.getPath());
            }
            catch (LastErrorException e) {
                if (LEE.getErrorCode(e) == 17) continue;
                throw new QueueException(String.format("cannot link(%s, %s): %s", tmp, newFile, e.getMessage()));
            }
            break;
        }
        try {
            posix.unlink(tmp.getPath());
        }
        catch (LastErrorException e) {
            throw new QueueException(String.format("cannot unlink(%s): %s", tmp, e.getMessage()));
        }
        return dir + File.separator + name;
    }

    private File _fileCreate(String path) throws QueueException {
        File file = null;
        try {
            file = posix.open(path);
        }
        catch (LastErrorException e) {
            if (LEE.getErrorCode(e) != 17 && LEE.getErrorCode(e) != 2) {
                throw new QueueException(String.format("cannot create %s: %s", path, e.getMessage()));
            }
            return null;
        }
        return file;
    }

    private File _addData(String dir, byte[] data) throws QueueException {
        File newFile = this._getNewFile(dir);
        try {
            FileUtils.writeToFile(newFile, data);
        }
        catch (IOException e) {
            throw new QueueException("cannot write to file: " + newFile);
        }
        return newFile;
    }

    private File _addData(String dir, String data) throws QueueException {
        File newFile = this._getNewFile(dir);
        try {
            FileUtils.writeToFile(newFile, data);
        }
        catch (IOException e) {
            throw new QueueException("cannot write to file: " + newFile);
        }
        return newFile;
    }

    private File _getNewFile(String dir) throws QueueException {
        File newFile = null;
        while (true) {
            String name = this._name();
            newFile = this._fileCreate(this.path + File.separator + dir + File.separator + name + TEMPORARY_SUFFIX);
            if (newFile != null) break;
            if (new File(this.path + File.separator + dir).exists()) continue;
            QueueSimple.specialMkdir(this.path + File.separator + dir);
        }
        return newFile;
    }

    @Override
    public String addPath(String path) throws QueueException {
        String dir = this._addDir();
        QueueSimple.specialMkdir(this.path + File.separator + dir, this.umask);
        return this._addPath(new File(path), dir);
    }

    protected String _addDir() {
        return String.format("%08x", System.currentTimeMillis() % (long)this.granularity);
    }

    @Override
    public String get(String name) {
        return FileUtils.readToString(this.path + File.separator + name + LOCKED_SUFFIX);
    }

    @Override
    public byte[] getAsByteArray(String name) {
        return FileUtils.readToByteArray(this.path + File.separator + name + LOCKED_SUFFIX);
    }

    @Override
    public String getPath(String name) {
        return this.path + File.separator + name + LOCKED_SUFFIX;
    }

    @Override
    public boolean lock(String name, boolean permissive) throws QueueException {
        File file = new File(this.path + File.separator + name);
        File lock = new File(this.path + File.separator + name + LOCKED_SUFFIX);
        try {
            posix.link(file.getPath(), lock.getPath());
        }
        catch (LastErrorException e) {
            if (permissive && (LEE.getErrorCode(e) == 17 || LEE.getErrorCode(e) == 2)) {
                return false;
            }
            throw new QueueException(String.format("cannot link(%s, %s): %s", file, lock, e.getMessage()));
        }
        try {
            posix.utimes(file.getPath(), null);
        }
        catch (LastErrorException e) {
            if (permissive && LEE.getErrorCode(e) == 2) {
                posix.unlink(lock.getPath());
                return false;
            }
            throw new QueueException(String.format("cannot utime(%s, null): %s", file, e.getMessage()));
        }
        return true;
    }

    @Override
    public boolean unlock(String name, boolean permissive) throws QueueException {
        String lock = this.path + File.separator + name + LOCKED_SUFFIX;
        try {
            posix.unlink(lock);
        }
        catch (LastErrorException e) {
            if (permissive && LEE.getErrorCode(e) == 2) {
                return false;
            }
            throw new QueueException(String.format("cannot unlink(%s): %s", lock, e.getMessage()));
        }
        return true;
    }

    @Override
    public void remove(String name) {
        posix.unlink(this.path + File.separator + name);
        posix.unlink(this.path + File.separator + name + LOCKED_SUFFIX);
    }

    @Override
    public int count() {
        File[] elements;
        int count = 0;
        for (File element : elements = new File(this.path).listFiles(new DirFilter())) {
            File[] inElements;
            for (File inElement : inElements = element.listFiles()) {
                if (!ElementRegexp.matcher(inElement.getName()).matches()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void purge(int maxTemp, int maxLock) throws QueueException {
        Object[] elements = new File(this.path).listFiles(new DirFilter());
        long now = System.currentTimeMillis() / 1000L;
        long oldtemp = now - (long)maxTemp;
        long oldlock = now - (long)maxLock;
        if (oldtemp > 0L || oldlock > 0L) {
            for (Object element : elements) {
                File[] inElements = ((File)element).listFiles(new RegExpFilenameFilter(Pattern.compile("\\."), false));
                if (inElements == null) continue;
                for (File inElement : inElements) {
                    FileStat stat = null;
                    try {
                        stat = posix.stat(inElement.getPath());
                    }
                    catch (LastErrorException e) {
                        throw new QueueException(String.format("cannot stat(%s): %s", inElement, e.getMessage()));
                    }
                    if (inElement.getName().endsWith(TEMPORARY_SUFFIX) && stat.mtime() >= oldtemp || inElement.getName().endsWith(LOCKED_SUFFIX) && stat.mtime() >= oldlock) continue;
                    this.warn("removing too old volatile file: " + inElement);
                    try {
                        posix.unlink(inElement.getPath());
                    }
                    catch (LastErrorException e) {
                        throw new QueueException(String.format("cannot unlink(%s): %s", inElement, e.getMessage()));
                    }
                }
            }
        }
        if (elements.length > 1) {
            Arrays.sort(elements);
            for (int c = 0; c < elements.length - 1; ++c) {
                if (!((File)elements[c]).exists() || ((File)elements[c]).listFiles().length != 0) continue;
                this.specialRmdir(((File)elements[c]).getPath());
            }
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new QueueSimpleIterator(this);
    }

    private void warn(String string) {
        if (!WARN) {
            return;
        }
        System.out.println(string);
        System.out.flush();
    }

    public class QueueSimpleIterator
    extends QueueIterator {
        public QueueSimpleIterator(Queue queue) {
            super(queue);
        }

        @Override
        public boolean buildElements() {
            while (!this.dirs.isEmpty()) {
                String dir = (String)this.dirs.remove(0);
                Object[] content = new File(this.queue.path + File.separator + dir).listFiles(new RegExpFilenameFilter(Queue.ElementRegexp));
                if (content == null || content.length == 0) continue;
                Arrays.sort(content);
                for (Object element : content) {
                    this.elts.add(dir + File.separator + ((File)element).getName());
                }
                return true;
            }
            return false;
        }
    }

    public class DirFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

