/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.json.JsonException;
import javax.json.stream.JsonGenerator;
import javax.org.glassfish.json.JsonGeneratorImpl;

public class JsonPrettyGeneratorImpl
extends JsonGeneratorImpl {
    private int indentLevel;
    private static final String INDENT = "    ";

    public JsonPrettyGeneratorImpl(Writer writer) {
        super(writer);
    }

    public JsonPrettyGeneratorImpl(OutputStream out) {
        super(out);
    }

    public JsonPrettyGeneratorImpl(OutputStream out, Charset encoding) {
        super(out, encoding);
    }

    @Override
    public JsonGenerator writeStartObject() {
        super.writeStartObject();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        super.writeStartObject(name);
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        super.writeStartArray();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        super.writeStartArray(name);
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        this.writeNewLine();
        --this.indentLevel;
        this.writeIndent();
        super.writeEnd();
        return this;
    }

    private void writeIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            try {
                this.writer.write(INDENT);
                continue;
            }
            catch (IOException e) {
                throw new JsonException("I/O error while writing indentation", (Throwable)e);
            }
        }
    }

    @Override
    protected void writeComma() throws IOException {
        super.writeComma();
        this.writer.write("\n");
        this.writeIndent();
    }

    private void writeNewLine() {
        try {
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing newline", (Throwable)e);
        }
    }
}

