/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.org.glassfish.json.JsonNumberImpl;
import javax.org.glassfish.json.JsonStringImpl;
import javax.org.glassfish.json.JsonWriterImpl;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private final List<JsonValue> valueList = new ArrayList<JsonValue>();

    JsonArrayBuilderImpl() {
    }

    public JsonArrayBuilder add(JsonValue value) {
        this.validateValue(value);
        this.valueList.add(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        this.validateValue(value);
        this.valueList.add((JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        this.validateValue(value);
        this.valueList.add((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        this.validateValue(value);
        this.valueList.add((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.valueList.add((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.valueList.add((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.valueList.add((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.valueList.add(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.valueList.add(JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("Object builder that is used to add a value to JSON array cannot be null");
        }
        this.valueList.add((JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("Array builder that is used to add a value to JSON array cannot be null");
        }
        this.valueList.add((JsonValue)builder.build());
        return this;
    }

    public JsonArray build() {
        ArrayList<JsonValue> snapshot = new ArrayList<JsonValue>(this.valueList);
        return new JsonArrayImpl(Collections.unmodifiableList(snapshot));
    }

    private void validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException("JsonArray's value cannot be null");
        }
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;

        JsonArrayImpl(List<JsonValue> valueList) {
            this.valueList = valueList;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        public JsonObject getJsonObject(int index) {
            return (JsonObject)this.valueList.get(index);
        }

        public JsonArray getJsonArray(int index) {
            return (JsonArray)this.valueList.get(index);
        }

        public JsonNumber getJsonNumber(int index) {
            return (JsonNumber)this.valueList.get(index);
        }

        public JsonString getJsonString(int index) {
            return (JsonString)this.valueList.get(index);
        }

        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.valueList;
        }

        public String getString(int index) {
            return this.getJsonString(index).getString();
        }

        public String getString(int index, String defaultValue) {
            try {
                return this.getString(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public int getInt(int index) {
            return this.getJsonNumber(index).intValue();
        }

        public int getInt(int index, int defaultValue) {
            try {
                return this.getInt(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean getBoolean(int index) {
            JsonValue jsonValue = this.get(index);
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        public boolean getBoolean(int index, boolean defaultValue) {
            try {
                return this.getBoolean(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean isNull(int index) {
            return this.valueList.get(index).equals(JsonValue.NULL);
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int index) {
            return this.valueList.get(index);
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriterImpl jw = new JsonWriterImpl(sw);
            jw.write((JsonStructure)this);
            jw.close();
            return sw.toString();
        }
    }
}

