/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;

class JsonGeneratorImpl
implements JsonGenerator {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final Writer writer;
    protected Context currentContext = new Context(Scope.IN_NONE);
    private final Deque<Context> stack = new ArrayDeque<Context>();

    JsonGeneratorImpl(Writer writer) {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.writer = writer;
    }

    JsonGeneratorImpl(OutputStream out) {
        this(out, UTF_8);
    }

    JsonGeneratorImpl(OutputStream out, Charset encoding) {
        this(new OutputStreamWriter(out, encoding));
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JsonException("I/O error while flushing JsonGenerator", (Throwable)e);
        }
    }

    public JsonGenerator writeStartObject() {
        if (this.currentContext.scope == Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartObject() cannot be called in object context");
        }
        if (this.currentContext.scope == Scope.IN_NONE && !this.currentContext.first) {
            throw new JsonGenerationException("writeStartObject() cannot be called in no context more than once");
        }
        try {
            this.writeComma();
            this.writer.write("{");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start object", (Throwable)ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_OBJECT);
        return this;
    }

    public JsonGenerator writeStartObject(String name) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartObject(String) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write("{");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start of object in JSON object", (Throwable)ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_OBJECT);
        return this;
    }

    private JsonGenerator writeName(String name) throws IOException {
        this.writeComma();
        JsonGeneratorImpl.writeEscapedString(this.writer, name);
        this.writer.write(":");
        return this;
    }

    public JsonGenerator write(String name, String fieldValue) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, String) can only be called in object context");
        }
        try {
            this.writeName(name);
            JsonGeneratorImpl.writeEscapedString(this.writer, fieldValue);
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, String) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(String name, int value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, int) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, int) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(String name, long value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, long) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, long) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(String name, double value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, double) can only be called in object context");
        }
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("write(String, double) value cannot be Infinite or NaN");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, double) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(String name, BigInteger value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, BigInteger) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, BigInteger) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(String name, BigDecimal value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, BigDecimal) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, BigDecimal) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(String name, boolean value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, boolean) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write(value ? "true" : "false");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing (name, boolean) pair in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator writeNull(String name) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeNull(String) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write("null");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing null value in JSON object", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(JsonValue) can only be called in array context");
        }
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.writeStartArray();
                for (JsonValue child : array) {
                    this.write(child);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject object = (JsonObject)value;
                this.writeStartObject();
                for (Map.Entry member : object.entrySet()) {
                    this.write((String)member.getKey(), (JsonValue)member.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString str = (JsonString)value;
                this.write(str.getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)value;
                try {
                    this.writeValue(number.toString());
                    break;
                }
                catch (IOException ioe) {
                    throw new JsonException("I/O error while writing a number", (Throwable)ioe);
                }
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        if (this.currentContext.scope == Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartArray() cannot be called in object context");
        }
        if (this.currentContext.scope == Scope.IN_NONE && !this.currentContext.first) {
            throw new JsonGenerationException("writeStartArray() cannot be called in no context more than once");
        }
        try {
            this.writeComma();
            this.writer.write("[");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start of JSON array", (Throwable)ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_ARRAY);
        return this;
    }

    public JsonGenerator writeStartArray(String name) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("writeStartArray(String) can only be called in object context");
        }
        try {
            this.writeName(name);
            this.writer.write("[");
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing start of array in JSON object", (Throwable)ioe);
        }
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_ARRAY);
        return this;
    }

    public JsonGenerator write(String name, JsonValue value) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException("write(String, JsonValue) can only be called in object context");
        }
        switch (value.getValueType()) {
            case ARRAY: {
                JsonArray array = (JsonArray)value;
                this.writeStartArray(name);
                for (JsonValue child : array) {
                    this.write(child);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject object = (JsonObject)value;
                this.writeStartObject(name);
                for (Map.Entry member : object.entrySet()) {
                    this.write((String)member.getKey(), (JsonValue)member.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString str = (JsonString)value;
                this.write(name, str.getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)value;
                try {
                    this.writeValue(name, number.toString());
                    break;
                }
                catch (IOException ioe) {
                    throw new JsonException("I/O error while writing a number in JSON object", (Throwable)ioe);
                }
            }
            case TRUE: {
                this.write(name, true);
                break;
            }
            case FALSE: {
                this.write(name, false);
                break;
            }
            case NULL: {
                this.writeNull(name);
            }
        }
        return this;
    }

    public JsonGenerator write(String value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(String) can only be called in array context");
        }
        try {
            this.writeComma();
            JsonGeneratorImpl.writeEscapedString(this.writer, value);
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing string value in JSON array", (Throwable)e);
        }
        return this;
    }

    public JsonGenerator write(int value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(int) can only be called in array context");
        }
        try {
            this.writeComma();
            this.writer.write(String.valueOf(value));
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing int value in JSON array", (Throwable)e);
        }
        return this;
    }

    public JsonGenerator write(long value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(long) can only be called in array context");
        }
        try {
            this.writeValue(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing long value in JSON array", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(double value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(double) can only be called in array context");
        }
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("write(double) value cannot be Infinite or NaN");
        }
        try {
            this.writeValue(String.valueOf(value));
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing double value in JSON array", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(BigInteger value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(BigInteger) can only be called in array context");
        }
        try {
            this.writeValue(value.toString());
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing BigInteger value in JSON array", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(BigDecimal) can only be called in array context");
        }
        try {
            this.writeValue(value.toString());
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while writing BigDecimal value in JSON array", (Throwable)ioe);
        }
        return this;
    }

    public JsonGenerator write(boolean value) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("write(boolean) can only be called in array context");
        }
        try {
            this.writeComma();
            this.writer.write(value ? "true" : "false");
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing boolean value in JSON array", (Throwable)e);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException("writeNull() can only be called in array context");
        }
        try {
            this.writeComma();
            this.writer.write("null");
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing null value in JSON array", (Throwable)e);
        }
        return this;
    }

    private void writeValue(String value) throws IOException {
        this.writeComma();
        this.writer.write(value);
    }

    private void writeValue(String name, String value) throws IOException {
        this.writeComma();
        JsonGeneratorImpl.writeEscapedString(this.writer, name);
        this.writer.write(58);
        this.writer.write(value);
    }

    public JsonGenerator writeEnd() {
        if (this.currentContext.scope == Scope.IN_NONE) {
            throw new JsonGenerationException("writeEnd() cannot be called in no context");
        }
        try {
            this.writer.write(this.currentContext.scope == Scope.IN_ARRAY ? 93 : 125);
        }
        catch (IOException e) {
            throw new JsonException("I/O error while writing end of JSON structure", (Throwable)e);
        }
        this.currentContext = this.stack.pop();
        return this;
    }

    protected void writeComma() throws IOException {
        if (!this.currentContext.first) {
            this.writer.write(",");
        }
        this.currentContext.first = false;
    }

    public void close() {
        if (this.currentContext.scope != Scope.IN_NONE || this.currentContext.first) {
            throw new JsonGenerationException("Generating incomplete JSON");
        }
        try {
            this.writer.close();
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while closing JsonGenerator", (Throwable)ioe);
        }
    }

    static void writeEscapedString(Writer w, String string) throws IOException {
        w.write(34);
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block8;
                }
                case '\b': {
                    w.write("\\b");
                    continue block8;
                }
                case '\f': {
                    w.write("\\f");
                    continue block8;
                }
                case '\n': {
                    w.write("\\n");
                    continue block8;
                }
                case '\r': {
                    w.write("\\r");
                    continue block8;
                }
                case '\t': {
                    w.write("\\t");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String hex = "000" + Integer.toHexString(c);
                        w.write("\\u" + hex.substring(hex.length() - 4));
                        continue block8;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
    }

    private static class Context {
        boolean first = true;
        final Scope scope;

        Context(Scope scope) {
            this.scope = scope;
        }
    }

    private static enum Scope {
        IN_NONE,
        IN_OBJECT,
        IN_ARRAY;

    }
}

