/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonNumberImpl
implements JsonNumber {
    private final BigDecimal bigDecimal;

    public JsonNumberImpl(int value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(long value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(BigInteger value) {
        this.bigDecimal = new BigDecimal(value);
    }

    public JsonNumberImpl(double value) {
        this.bigDecimal = BigDecimal.valueOf(value);
    }

    public JsonNumberImpl(BigDecimal value) {
        this.bigDecimal = value;
    }

    public boolean isIntegral() {
        return this.bigDecimal.scale() == 0;
    }

    public int intValue() {
        return this.bigDecimal.intValue();
    }

    public int intValueExact() {
        return this.bigDecimal.intValueExact();
    }

    public long longValue() {
        return this.bigDecimal.longValue();
    }

    public long longValueExact() {
        return this.bigDecimal.longValueExact();
    }

    public BigInteger bigIntegerValue() {
        return this.bigDecimal.toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return this.bigDecimal.toBigIntegerExact();
    }

    public double doubleValue() {
        return this.bigDecimal.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.bigDecimal;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonNumber)) {
            return false;
        }
        JsonNumber other = (JsonNumber)obj;
        return this.bigDecimalValue().equals(other.bigDecimalValue());
    }

    public String toString() {
        return this.bigDecimal.toString();
    }
}

