/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.org.glassfish.json.JsonNumberImpl;
import javax.org.glassfish.json.JsonStringImpl;
import javax.org.glassfish.json.JsonWriterImpl;

class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private final Map<String, JsonValue> valueMap = new LinkedHashMap<String, JsonValue>();

    JsonObjectBuilderImpl() {
    }

    public JsonObjectBuilder add(String name, JsonValue value) {
        this.validateName(name);
        this.validateValue(value);
        this.valueMap.put(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, String value) {
        this.validateName(name);
        this.validateValue(value);
        this.valueMap.put(name, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigInteger value) {
        this.validateName(name);
        this.validateValue(value);
        this.valueMap.put(name, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.validateName(name);
        this.validateValue(value);
        this.valueMap.put(name, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, int value) {
        this.validateName(name);
        this.valueMap.put(name, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, long value) {
        this.validateName(name);
        this.valueMap.put(name, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, double value) {
        this.validateName(name);
        this.valueMap.put(name, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, boolean value) {
        this.validateName(name);
        this.valueMap.put(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonObjectBuilder addNull(String name) {
        this.validateName(name);
        this.valueMap.put(name, JsonValue.NULL);
        return this;
    }

    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.validateName(name);
        if (builder == null) {
            throw new NullPointerException("Object builder that is used to create a value in JsonObject's name/value pair cannot be null");
        }
        this.valueMap.put(name, (JsonValue)builder.build());
        return this;
    }

    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.validateName(name);
        if (builder == null) {
            throw new NullPointerException("Array builder that is used to create a value in JsonObject's name/value pair cannot be null");
        }
        this.valueMap.put(name, (JsonValue)builder.build());
        return this;
    }

    public JsonObject build() {
        LinkedHashMap<String, JsonValue> snapshot = new LinkedHashMap<String, JsonValue>(this.valueMap);
        return new JsonObjectImpl(Collections.unmodifiableMap(snapshot));
    }

    private void validateName(String name) {
        if (name == null) {
            throw new NullPointerException("Name in JsonObject's name/value pair cannot be null");
        }
    }

    private void validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Value in JsonObject's name/value pair cannot be null");
        }
    }

    private static final class JsonObjectImpl
    extends AbstractMap<String, JsonValue>
    implements JsonObject {
        private final Map<String, JsonValue> valueMap;

        JsonObjectImpl(Map<String, JsonValue> valueMap) {
            this.valueMap = valueMap;
        }

        public JsonArray getJsonArray(String name) {
            return (JsonArray)this.get(name);
        }

        public JsonObject getJsonObject(String name) {
            return (JsonObject)this.get(name);
        }

        public JsonNumber getJsonNumber(String name) {
            return (JsonNumber)this.get(name);
        }

        public JsonString getJsonString(String name) {
            return (JsonString)this.get(name);
        }

        public String getString(String name) {
            return this.getJsonString(name).getString();
        }

        public String getString(String name, String defaultValue) {
            try {
                return this.getString(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public int getInt(String name) {
            return this.getJsonNumber(name).intValue();
        }

        public int getInt(String name, int defaultValue) {
            try {
                return this.getInt(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean getBoolean(String name) {
            JsonValue value = (JsonValue)this.get(name);
            if (value == null) {
                throw new NullPointerException();
            }
            if (value == JsonValue.TRUE) {
                return true;
            }
            if (value == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            try {
                return this.getBoolean(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean isNull(String name) {
            return ((JsonValue)this.get(name)).equals(JsonValue.NULL);
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.OBJECT;
        }

        @Override
        public Set<Map.Entry<String, JsonValue>> entrySet() {
            return this.valueMap.entrySet();
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriterImpl jw = new JsonWriterImpl(sw);
            jw.write((JsonStructure)this);
            jw.close();
            return sw.toString();
        }
    }
}

