/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import javax.org.glassfish.json.JsonTokenizer;
import javax.org.glassfish.json.UnicodeDetectingInputStream;

public class JsonParserImpl
implements JsonParser {
    private State currentState = State.START_DOCUMENT;
    private Context currentContext = new NoneContext(this);
    private JsonParser.Event currentEvent;
    private final Deque<Context> stack = new ArrayDeque<Context>();
    private final StateIterator stateIterator;
    private final JsonTokenizer tokenizer;

    public JsonParserImpl(Reader reader) {
        this.tokenizer = new JsonTokenizer(reader);
        this.stateIterator = new StateIterator();
    }

    public JsonParserImpl(InputStream in) {
        UnicodeDetectingInputStream uin = new UnicodeDetectingInputStream(in);
        this.tokenizer = new JsonTokenizer(new InputStreamReader((InputStream)uin, uin.getCharset()));
        this.stateIterator = new StateIterator();
    }

    public JsonParserImpl(InputStream in, Charset encoding) {
        this.tokenizer = new JsonTokenizer(new InputStreamReader(in, encoding));
        this.stateIterator = new StateIterator();
    }

    public String getString() {
        if (this.currentEvent == JsonParser.Event.KEY_NAME || this.currentEvent == JsonParser.Event.VALUE_STRING || this.currentEvent == JsonParser.Event.VALUE_NUMBER) {
            return this.tokenizer.getValue();
        }
        throw new IllegalStateException("JsonParser#getString() is valid only KEY_NAME, VALUE_STRING, VALUE_NUMBER parser states. But current parser state is " + this.currentEvent);
    }

    public boolean isIntegralNumber() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#isIntegralNumber() is valid only VALUE_NUMBER parser state. But current parser state is " + this.currentEvent);
        }
        BigDecimal bigDecimal = new BigDecimal(this.tokenizer.getValue());
        return bigDecimal.scale() == 0;
    }

    public int getInt() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#getNumberType() is valid only VALUE_NUMBER parser state. But current parser state is " + this.currentEvent);
        }
        return new BigDecimal(this.tokenizer.getValue()).intValue();
    }

    public long getLong() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#getNumberType() is valid only VALUE_NUMBER parser state. But current parser state is " + this.currentEvent);
        }
        return new BigDecimal(this.tokenizer.getValue()).longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("JsonParser#getNumberType() is valid only VALUE_NUMBER parser state. But current parser state is " + this.currentEvent);
        }
        return new BigDecimal(this.tokenizer.getValue());
    }

    public JsonLocation getLocation() {
        return this.tokenizer.getLocation();
    }

    public JsonLocation getLastCharLocation() {
        return this.tokenizer.getLastCharLocation();
    }

    public boolean hasNext() {
        return this.stateIterator.hasNext();
    }

    public JsonParser.Event next() {
        return this.stateIterator.next();
    }

    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException e) {
            throw new JsonException("I/O error while closing JSON tokenizer", (Throwable)e);
        }
    }

    private static enum State {
        INVALID,
        START_DOCUMENT,
        START_OBJECT,
        KEY,
        COLON,
        OBJECT_STRING,
        OBJECT_NUMBER,
        OBJECT_TRUE,
        OBJECT_FALSE,
        OBJECT_NULL,
        OBJECT_COMMA,
        END_OBJECT,
        START_ARRAY,
        ARRAY_STRING,
        ARRAY_NUMBER,
        ARRAY_TRUE,
        ARRAY_FALSE,
        ARRAY_NULL,
        ARRAY_COMMA,
        END_ARRAY,
        END_DOCUMENT;

    }

    private static class ArrayContext
    extends Context {
        private static final State[][] TRANSITIONS = new State[State.values().length][JsonTokenizer.JsonToken.values().length];
        private static final EnumMap<State, Set<JsonTokenizer.JsonToken>> EXPECTED_TOKENS = new EnumMap(State.class);

        ArrayContext(JsonParserImpl parser) {
            super(parser);
        }

        static void transition(State current, JsonTokenizer.JsonToken token, State next) {
            ArrayContext.transition(TRANSITIONS, EXPECTED_TOKENS, current, token, next);
        }

        @Override
        State[][] getTransitions() {
            return TRANSITIONS;
        }

        @Override
        EnumMap<State, Set<JsonTokenizer.JsonToken>> getExpectedTokens() {
            return EXPECTED_TOKENS;
        }

        static {
            for (int i = 0; i < TRANSITIONS.length; ++i) {
                for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                    ArrayContext.TRANSITIONS[i][j] = State.INVALID;
                }
            }
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.STRING, State.ARRAY_STRING);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.NUMBER, State.ARRAY_NUMBER);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.TRUE, State.ARRAY_TRUE);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.FALSE, State.ARRAY_FALSE);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.NULL, State.ARRAY_NULL);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.CURLYOPEN, State.START_OBJECT);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.SQUAREOPEN, State.START_ARRAY);
            ArrayContext.transition(State.START_ARRAY, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.ARRAY_STRING, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.ARRAY_STRING, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.ARRAY_NUMBER, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.ARRAY_NUMBER, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.ARRAY_TRUE, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.ARRAY_TRUE, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.ARRAY_FALSE, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.ARRAY_FALSE, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.ARRAY_NULL, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.ARRAY_NULL, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.STRING, State.ARRAY_STRING);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.NUMBER, State.ARRAY_NUMBER);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.TRUE, State.ARRAY_TRUE);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.FALSE, State.ARRAY_FALSE);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.NULL, State.ARRAY_NULL);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.CURLYOPEN, State.START_OBJECT);
            ArrayContext.transition(State.ARRAY_COMMA, JsonTokenizer.JsonToken.SQUAREOPEN, State.START_ARRAY);
            ArrayContext.transition(State.END_ARRAY, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
            ArrayContext.transition(State.END_ARRAY, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.END_ARRAY, JsonTokenizer.JsonToken.EOF, State.END_DOCUMENT);
            ArrayContext.transition(State.END_OBJECT, JsonTokenizer.JsonToken.COMMA, State.ARRAY_COMMA);
            ArrayContext.transition(State.END_OBJECT, JsonTokenizer.JsonToken.SQUARECLOSE, State.END_ARRAY);
        }
    }

    private static class ObjectContext
    extends Context {
        private static final State[][] TRANSITIONS = new State[State.values().length][JsonTokenizer.JsonToken.values().length];
        private static final EnumMap<State, Set<JsonTokenizer.JsonToken>> EXPECTED_TOKENS = new EnumMap(State.class);

        ObjectContext(JsonParserImpl parser) {
            super(parser);
        }

        static void transition(State current, JsonTokenizer.JsonToken token, State next) {
            ObjectContext.transition(TRANSITIONS, EXPECTED_TOKENS, current, token, next);
        }

        @Override
        State[][] getTransitions() {
            return TRANSITIONS;
        }

        @Override
        EnumMap<State, Set<JsonTokenizer.JsonToken>> getExpectedTokens() {
            return EXPECTED_TOKENS;
        }

        static {
            for (int i = 0; i < TRANSITIONS.length; ++i) {
                for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                    ObjectContext.TRANSITIONS[i][j] = State.INVALID;
                }
            }
            ObjectContext.transition(State.START_OBJECT, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.START_OBJECT, JsonTokenizer.JsonToken.STRING, State.KEY);
            ObjectContext.transition(State.KEY, JsonTokenizer.JsonToken.COLON, State.COLON);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.STRING, State.OBJECT_STRING);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.NUMBER, State.OBJECT_NUMBER);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.TRUE, State.OBJECT_TRUE);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.FALSE, State.OBJECT_FALSE);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.NULL, State.OBJECT_NULL);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.CURLYOPEN, State.START_OBJECT);
            ObjectContext.transition(State.COLON, JsonTokenizer.JsonToken.SQUAREOPEN, State.START_ARRAY);
            ObjectContext.transition(State.OBJECT_STRING, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.OBJECT_STRING, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.OBJECT_NUMBER, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.OBJECT_NUMBER, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.OBJECT_TRUE, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.OBJECT_TRUE, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.OBJECT_FALSE, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.OBJECT_FALSE, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.OBJECT_NULL, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.OBJECT_NULL, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.OBJECT_COMMA, JsonTokenizer.JsonToken.STRING, State.KEY);
            ObjectContext.transition(State.END_OBJECT, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
            ObjectContext.transition(State.END_OBJECT, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.END_OBJECT, JsonTokenizer.JsonToken.EOF, State.END_DOCUMENT);
            ObjectContext.transition(State.END_ARRAY, JsonTokenizer.JsonToken.COMMA, State.OBJECT_COMMA);
            ObjectContext.transition(State.END_ARRAY, JsonTokenizer.JsonToken.CURLYCLOSE, State.END_OBJECT);
        }
    }

    private static class NoneContext
    extends Context {
        private static final State[][] TRANSITIONS = new State[State.values().length][JsonTokenizer.JsonToken.values().length];
        private static final EnumMap<State, Set<JsonTokenizer.JsonToken>> EXPECTED_TOKENS = new EnumMap(State.class);

        NoneContext(JsonParserImpl parser) {
            super(parser);
        }

        @Override
        State[][] getTransitions() {
            return TRANSITIONS;
        }

        @Override
        EnumMap<State, Set<JsonTokenizer.JsonToken>> getExpectedTokens() {
            return EXPECTED_TOKENS;
        }

        static void transition(State current, JsonTokenizer.JsonToken token, State next) {
            NoneContext.transition(TRANSITIONS, EXPECTED_TOKENS, current, token, next);
        }

        static {
            for (int i = 0; i < TRANSITIONS.length; ++i) {
                for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                    NoneContext.TRANSITIONS[i][j] = State.INVALID;
                }
            }
            NoneContext.transition(State.START_DOCUMENT, JsonTokenizer.JsonToken.CURLYOPEN, State.START_OBJECT);
            NoneContext.transition(State.START_DOCUMENT, JsonTokenizer.JsonToken.SQUAREOPEN, State.START_ARRAY);
        }
    }

    private static abstract class Context {
        final JsonParserImpl parser;

        Context(JsonParserImpl parser) {
            this.parser = parser;
        }

        abstract State[][] getTransitions();

        abstract EnumMap<State, Set<JsonTokenizer.JsonToken>> getExpectedTokens();

        State getTransition(State current, JsonTokenizer.JsonToken token) {
            State state = this.getTransitions()[current.ordinal()][token.ordinal()];
            if (state == State.INVALID) {
                throw new JsonParsingException("Invalid token " + (Object)((Object)token) + " at " + this.parser.getLastCharLocation() + ", " + "Expected Tokens " + this.getExpectedTokens().get((Object)current), this.parser.getLastCharLocation());
            }
            return state;
        }

        static void transition(State[][] TRANSITIONS, EnumMap<State, Set<JsonTokenizer.JsonToken>> EXPECTED_TOKENS, State current, JsonTokenizer.JsonToken token, State next) {
            TRANSITIONS[current.ordinal()][token.ordinal()] = next;
            Set<JsonTokenizer.JsonToken> allowed = EXPECTED_TOKENS.get((Object)current);
            if (allowed == null) {
                allowed = EnumSet.noneOf(JsonTokenizer.JsonToken.class);
                EXPECTED_TOKENS.put(current, allowed);
            }
            allowed.add(token);
        }
    }

    private class StateIterator
    implements Iterator<JsonParser.Event> {
        private StateIterator() {
        }

        private JsonTokenizer.JsonToken nextToken() {
            try {
                return JsonParserImpl.this.tokenizer.nextToken();
            }
            catch (IOException ioe) {
                throw new JsonException("I/O error while moving parser to next state", (Throwable)ioe);
            }
        }

        @Override
        public boolean hasNext() {
            if (JsonParserImpl.this.stack.isEmpty() && (JsonParserImpl.this.currentState == State.END_ARRAY || JsonParserImpl.this.currentState == State.END_OBJECT)) {
                JsonTokenizer.JsonToken token = this.nextToken();
                if (token != JsonTokenizer.JsonToken.EOF) {
                    throw new JsonParsingException("Expected EOF, but got=" + (Object)((Object)token), JsonParserImpl.this.getLastCharLocation());
                }
                return false;
            }
            return true;
        }

        @Override
        public JsonParser.Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            block21: while (true) {
                JsonTokenizer.JsonToken token = this.nextToken();
                JsonParserImpl.this.currentState = JsonParserImpl.this.currentContext.getTransition(JsonParserImpl.this.currentState, token);
                switch (JsonParserImpl.this.currentState) {
                    case START_DOCUMENT: {
                        continue block21;
                    }
                    case START_OBJECT: {
                        JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                        JsonParserImpl.this.currentContext = new ObjectContext(JsonParserImpl.this);
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.START_OBJECT;
                    }
                    case KEY: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.KEY_NAME;
                    }
                    case COLON: {
                        continue block21;
                    }
                    case OBJECT_STRING: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_STRING;
                    }
                    case OBJECT_NUMBER: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NUMBER;
                    }
                    case OBJECT_TRUE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_TRUE;
                    }
                    case OBJECT_FALSE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_FALSE;
                    }
                    case OBJECT_NULL: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NULL;
                    }
                    case OBJECT_COMMA: {
                        continue block21;
                    }
                    case END_OBJECT: {
                        JsonParserImpl.this.currentContext = (Context)JsonParserImpl.this.stack.pop();
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.END_OBJECT;
                    }
                    case START_ARRAY: {
                        JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                        JsonParserImpl.this.currentContext = new ArrayContext(JsonParserImpl.this);
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.START_ARRAY;
                    }
                    case ARRAY_STRING: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_STRING;
                    }
                    case ARRAY_NUMBER: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NUMBER;
                    }
                    case ARRAY_TRUE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_TRUE;
                    }
                    case ARRAY_FALSE: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_FALSE;
                    }
                    case ARRAY_NULL: {
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.VALUE_NULL;
                    }
                    case ARRAY_COMMA: {
                        continue block21;
                    }
                    case END_ARRAY: {
                        JsonParserImpl.this.currentContext = (Context)JsonParserImpl.this.stack.pop();
                        return JsonParserImpl.this.currentEvent = JsonParser.Event.END_ARRAY;
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

