/*
 * Decompiled with CFR 0.152.
 */
package javax.org.glassfish.json;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParsingException;
import javax.org.glassfish.json.JsonLocationImpl;

final class JsonTokenizer
implements Closeable {
    private final TokenizerReader reader;
    private boolean unread;
    private int prevChar;
    private long lineNo = 1L;
    private long columnNo = 1L;
    private long streamOffset = 0L;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    JsonTokenizer(Reader reader) {
        this.reader = new DirectReader(reader);
    }

    private int read() {
        int ch;
        if (this.unread) {
            this.unread = false;
            ch = this.prevChar;
        } else {
            ch = this.reader.readChar();
        }
        if (ch == 13 || this.prevChar != 13 && ch == 10) {
            ++this.lineNo;
            this.columnNo = 1L;
        } else if (this.prevChar != 13 || ch != 10) {
            ++this.columnNo;
        }
        ++this.streamOffset;
        this.prevChar = ch;
        return ch;
    }

    private void store(char ch) {
        this.reader.storeChar(ch);
    }

    private void unread(int ch) {
        this.prevChar = ch;
        this.unread = true;
        --this.streamOffset;
        --this.columnNo;
    }

    private void readString() {
        int ch;
        do {
            ch = this.read();
            block0 : switch (ch) {
                case -1: {
                    throw new JsonException("Unexpected EOF");
                }
                case 92: {
                    int ch2 = this.read();
                    switch (ch2) {
                        case 98: {
                            this.store('\b');
                            break block0;
                        }
                        case 116: {
                            this.store('\t');
                            break block0;
                        }
                        case 110: {
                            this.store('\n');
                            break block0;
                        }
                        case 102: {
                            this.store('\f');
                            break block0;
                        }
                        case 114: {
                            this.store('\r');
                            break block0;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            this.store((char)ch2);
                            break block0;
                        }
                        case 117: {
                            int unicode = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch3 = this.read();
                                unicode = (char)(unicode << 4);
                                if (ch3 >= 48 && ch3 <= 57) {
                                    unicode = (char)(unicode | (char)ch3 - 48);
                                    continue;
                                }
                                if (ch3 >= 97 && ch3 <= 102) {
                                    unicode = (char)(unicode | (char)ch3 - 97 + 10);
                                    continue;
                                }
                                if (ch3 >= 65 && ch3 <= 70) {
                                    unicode = (char)(unicode | (char)ch3 - 65 + 10);
                                    continue;
                                }
                                throw new JsonParsingException("Unexpected Char=" + ch3, this.getLastCharLocation());
                            }
                            this.store((char)(unicode & 0xFFFF));
                            break block0;
                        }
                    }
                    throw new JsonParsingException("Unexpected Char=" + ch2, this.getLastCharLocation());
                }
                case 34: {
                    break;
                }
                default: {
                    if (ch >= 0 && ch <= 31 || ch >= 127 && ch <= 159) {
                        throw new JsonException("Unexpected Char=" + ch);
                    }
                    this.store((char)ch);
                }
            }
        } while (ch != 34);
    }

    private void readNumber(int ch) {
        int count;
        if (ch == 45) {
            this.store((char)ch);
            ch = this.read();
            if (ch < 48 || ch > 57) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        if (ch == 48) {
            this.store((char)ch);
            ch = this.read();
        } else {
            do {
                this.store((char)ch);
            } while ((ch = this.read()) >= 48 && ch <= 57);
        }
        if (ch == 46) {
            count = 0;
            do {
                this.store((char)ch);
                ch = this.read();
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        if (ch == 101 || ch == 69) {
            this.store((char)ch);
            ch = this.read();
            if (ch == 43 || ch == 45) {
                this.store((char)ch);
                ch = this.read();
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                this.store((char)ch);
                ch = this.read();
                ++count;
            }
            if (count == 0) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        this.unread(ch);
    }

    private void readTrue() {
        char ch1 = (char)this.read();
        if (ch1 != 'r') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'r'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'u') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'u'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 'e') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 'e'", this.getLastCharLocation());
        }
    }

    private void readFalse() {
        char ch1 = (char)this.read();
        if (ch1 != 'a') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'a'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'l'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 's') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 's'", this.getLastCharLocation());
        }
        char ch4 = (char)this.read();
        if (ch4 != 'e') {
            throw new JsonParsingException("Unexpected Char=" + ch4 + " expecting 'e'", this.getLastCharLocation());
        }
    }

    private void readNull() {
        char ch1 = (char)this.read();
        if (ch1 != 'u') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'u'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'l'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 'l'", this.getLastCharLocation());
        }
    }

    JsonToken nextToken() throws IOException {
        this.reader.reset();
        int ch = this.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = this.read();
        }
        switch (ch) {
            case -1: {
                return JsonToken.EOF;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 45: {
                this.readNumber(ch);
                return JsonToken.NUMBER;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
        }
        if (ch >= 48 && ch <= 57) {
            this.readNumber(ch);
            return JsonToken.NUMBER;
        }
        throw new JsonParsingException("Unexpected char=" + (char)ch, this.getLastCharLocation());
    }

    String getValue() {
        return this.reader.getValue();
    }

    JsonLocation getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.columnNo - 1L, this.streamOffset - 1L);
    }

    JsonLocation getLocation() {
        return new JsonLocationImpl(this.lineNo, this.columnNo, this.streamOffset);
    }

    private static class DirectReader
    implements TokenizerReader {
        private final Reader reader;
        private char[] buf = new char[8192];
        private int len;
        private String value;

        DirectReader(Reader reader) {
            if (!(reader instanceof BufferedReader)) {
                reader = new BufferedReader(reader);
            }
            this.reader = reader;
        }

        @Override
        public int readChar() {
            try {
                return this.reader.read();
            }
            catch (IOException ioe) {
                throw new JsonException("I/O error while tokenizing JSON", (Throwable)ioe);
            }
        }

        @Override
        public void storeChar(int ch) {
            if (this.len == this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, 2 * this.buf.length);
            }
            this.buf[this.len++] = (char)ch;
        }

        @Override
        public void reset() {
            this.len = 0;
            this.value = null;
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                this.value = new String(this.buf, 0, this.len);
            }
            return this.value;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static interface TokenizerReader
    extends Closeable {
        public int readChar();

        public void storeChar(int var1);

        public void reset();

        public String getValue();
    }

    static enum JsonToken {
        CURLYOPEN,
        SQUAREOPEN,
        COLON,
        COMMA,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL,
        CURLYCLOSE,
        SQUARECLOSE,
        EOF;

    }
}

