/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.util.PrimitiveIterator;
import java.util.Random;

public class CustomGenerators {
    public int randomInt(int min, int max) {
        return new IntRandomNumberGenerator(min, max).nextInt();
    }

    public double randomDouble(double min, double max) {
        return new DoubleRandomNumberGenerator(min, max).nextDouble();
    }

    public static final class IntRandomNumberGenerator {
        private PrimitiveIterator.OfInt randomIterator;
        private int min;
        private int max;
        private static final int DEFAULT_MIN = 120;
        private static final int DEFAULT_MAX = 420;

        public IntRandomNumberGenerator() {
            this.min = 120;
            this.max = 420;
        }

        public IntRandomNumberGenerator(int min, int max) {
            this.min = min;
            this.max = max;
            this.randomIterator = new Random().ints(min, max + 1).iterator();
        }

        public IntRandomNumberGenerator setMin(int min) {
            this.min = min;
            return this;
        }

        public IntRandomNumberGenerator setMax(int max) {
            this.max = max;
            return this;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int nextInt() {
            if (this.randomIterator == null) {
                this.randomIterator = new Random().ints(this.min, this.max + 1).iterator();
            }
            return this.randomIterator.nextInt();
        }
    }

    public static final class DoubleRandomNumberGenerator {
        private PrimitiveIterator.OfDouble randomIterator;
        private double min;
        private double max;

        public DoubleRandomNumberGenerator() {
            this.min = 0.0;
            this.max = 1.0;
        }

        public DoubleRandomNumberGenerator(double min, double max) {
            this.min = min;
            this.max = max;
            this.randomIterator = new Random().doubles(min, Math.nextUp(max)).iterator();
        }

        public DoubleRandomNumberGenerator setMin(double min) {
            this.min = min;
            return this;
        }

        public DoubleRandomNumberGenerator setMax(double max) {
            this.max = max;
            return this;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double nextDouble() {
            if (this.randomIterator == null) {
                this.randomIterator = new Random().doubles(this.min, Math.nextUp(this.max)).iterator();
            }
            return this.randomIterator.nextDouble();
        }
    }
}

