/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MyFormatter
extends Formatter {
    private static final DateFormat df = new SimpleDateFormat("dd/MM/yyyy | HH:mm:ss");
    private final boolean timeFormat;

    public MyFormatter(boolean timeFormat) {
        this.timeFormat = timeFormat;
    }

    public MyFormatter() {
        this.timeFormat = false;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder(1000);
        if (this.timeFormat) {
            builder.append(df.format(new Date(record.getMillis()))).append(" - ");
        }
        builder.append("[").append(record.getLoggerName()).append("] - ");
        builder.append("[").append(record.getLevel()).append("] : ");
        builder.append(this.formatMessage(record));
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public String getHead(Handler h) {
        return super.getHead(h);
    }

    @Override
    public String getTail(Handler h) {
        return super.getTail(h);
    }

    public Logger createEmptyLogger(String name) {
        Logger logger = Logger.getLogger(name);
        logger.setUseParentHandlers(false);
        MyFormatter formatter = new MyFormatter(this.timeFormat);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        handler.setFormatter(formatter);
        logger.addHandler(handler);
        return logger;
    }
}

