/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.rest;

import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.model.CertificateData;
import ch.swisscom.mid.client.model.ProfileDeviceInfo;
import ch.swisscom.mid.client.model.ProfileDevicePinState;
import ch.swisscom.mid.client.model.ProfileDeviceState;
import ch.swisscom.mid.client.model.ProfileMobileUserCertificate;
import ch.swisscom.mid.client.model.ProfileMobileUserCertificateState;
import ch.swisscom.mid.client.model.ProfileMobileUserInfo;
import ch.swisscom.mid.client.model.ProfileRequest;
import ch.swisscom.mid.client.model.ProfileResponse;
import ch.swisscom.mid.client.rest.model.profqreq.APInfo;
import ch.swisscom.mid.client.rest.model.profqreq.MSSPInfo;
import ch.swisscom.mid.client.rest.model.profqreq.MSSProfileQueryRequest;
import ch.swisscom.mid.client.rest.model.profqreq.MSSProfileReq;
import ch.swisscom.mid.client.rest.model.profqreq.MsspId;
import ch.swisscom.mid.client.rest.model.profqresp.App;
import ch.swisscom.mid.client.rest.model.profqresp.MSSProfileQueryResponse;
import ch.swisscom.mid.client.rest.model.profqresp.MSSProfileResp;
import ch.swisscom.mid.client.rest.model.profqresp.MobileUser;
import ch.swisscom.mid.client.rest.model.profqresp.MobileUserCertificate;
import ch.swisscom.mid.client.rest.model.profqresp.PinStatus;
import ch.swisscom.mid.client.rest.model.profqresp.ProfileQueryExtension;
import ch.swisscom.mid.client.rest.model.profqresp.Sim;
import ch.swisscom.mid.client.rest.model.profqresp.Sscds;
import ch.swisscom.mid.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class ProfileRequestModelUtils {
    public static MSSProfileQueryRequest createProfileQueryRequest(ProfileRequest request, ClientConfiguration config) {
        MSSProfileReq mssRequest = new MSSProfileReq();
        mssRequest.setAPInfo(ProfileRequestModelUtils.createApInfo(config));
        mssRequest.setMajorVersion(request.getMajorVersion());
        mssRequest.setMinorVersion(request.getMinorVersion());
        mssRequest.setMSSPInfo(ProfileRequestModelUtils.createMsspInfo(config));
        mssRequest.setMobileUser(ProfileRequestModelUtils.createMobileUser(request));
        mssRequest.setParams(Utils.joinListOfStrings((List)request.getExtensionParams(), (String)" "));
        MSSProfileQueryRequest mssRequestWrapper = new MSSProfileQueryRequest();
        mssRequestWrapper.setMSSProfileReq(mssRequest);
        return mssRequestWrapper;
    }

    public static ProfileResponse processProfileQueryResponse(MSSProfileQueryResponse mssResponseWrapper) {
        ProfileResponse response = new ProfileResponse();
        MSSProfileResp mssResponse = mssResponseWrapper.getMSSProfileResp();
        response.setSignatureProfiles(mssResponse.getSignatureProfile());
        if (mssResponse.getStatus() != null && mssResponse.getStatus().getStatusDetail() != null && mssResponse.getStatus().getStatusDetail().getProfileQueryExtension() != null) {
            ProfileQueryExtension mssPQExt = mssResponse.getStatus().getStatusDetail().getProfileQueryExtension();
            if (mssPQExt.getMobileUser() != null) {
                ProfileMobileUserInfo mobileUserInfo = new ProfileMobileUserInfo();
                MobileUser mssPQMobileUser = mssPQExt.getMobileUser();
                if (mssPQMobileUser.getRecoveryCodeCreated() != null) {
                    mobileUserInfo.setRecoveryCodeCreated(mssPQMobileUser.getRecoveryCodeCreated().booleanValue());
                }
                if (mssPQMobileUser.getAutoActivation() != null) {
                    mobileUserInfo.setAutoActivation(mssPQMobileUser.getAutoActivation().booleanValue());
                }
                response.setMobileUser(mobileUserInfo);
            }
            if (mssPQExt.getSscds() != null) {
                response.setSimDevices(new ArrayList());
                response.setAppDevices(new ArrayList());
                Sscds mssSscds = mssPQExt.getSscds();
                if (mssSscds.getSim() != null) {
                    Sim mssSim = mssSscds.getSim();
                    response.getSimDevices().add(ProfileRequestModelUtils.processDeviceInfo(mssSim::getState, mssSim::getPinStatus, mssSim::getMobileUserCertificate));
                }
                if (mssSscds.getApp() != null && mssSscds.getApp().size() > 0) {
                    List<App> mssAppList = mssSscds.getApp();
                    for (App mssApp : mssAppList) {
                        response.getAppDevices().add(ProfileRequestModelUtils.processDeviceInfo(mssApp::getState, mssApp::getPinStatus, mssApp::getMobileUserCertificate));
                    }
                }
            }
        }
        return response;
    }

    private static APInfo createApInfo(ClientConfiguration config) {
        APInfo apInfo = new APInfo();
        apInfo.setApId(config.getApId());
        apInfo.setApPwd(config.getApPassword());
        apInfo.setAPTransID(Utils.generateTransId());
        apInfo.setInstant(Utils.generateInstantAsString());
        return apInfo;
    }

    private static ch.swisscom.mid.client.rest.model.profqreq.MobileUser createMobileUser(ProfileRequest request) {
        ch.swisscom.mid.client.rest.model.profqreq.MobileUser mobileUser = new ch.swisscom.mid.client.rest.model.profqreq.MobileUser();
        mobileUser.setMsisdn(request.getMobileUser().getMsisdn());
        return mobileUser;
    }

    private static MSSPInfo createMsspInfo(ClientConfiguration config) {
        MsspId msspId = new MsspId();
        msspId.setUri(config.getMsspId());
        MSSPInfo msspInfo = new MSSPInfo();
        msspInfo.setMsspId(msspId);
        return msspInfo;
    }

    private static ProfileDeviceInfo processDeviceInfo(Supplier<String> stateSupplier, Supplier<PinStatus> pinStatusSupplier, Supplier<List<MobileUserCertificate>> certificateListSupplier) {
        ProfileDeviceInfo deviceInfo = new ProfileDeviceInfo();
        deviceInfo.setState(ProfileDeviceState.getByStateString((String)stateSupplier.get()));
        if (pinStatusSupplier.get() != null) {
            deviceInfo.setPinState(ProfileDevicePinState.getByPinBlockedBooleanValue((Boolean)pinStatusSupplier.get().getBlocked()));
        }
        if (certificateListSupplier.get() != null && certificateListSupplier.get().size() > 0) {
            deviceInfo.setCertificates(new ArrayList());
            for (MobileUserCertificate mssCert : certificateListSupplier.get()) {
                CertificateData certificateData;
                int index;
                ProfileMobileUserCertificate cert = new ProfileMobileUserCertificate();
                cert.setAlgorithm(mssCert.getAlgorithm());
                cert.setState(ProfileMobileUserCertificateState.getByStateString((String)mssCert.getState()));
                CertificateData userCertificate = new CertificateData();
                ArrayList<CertificateData> caCertificates = new ArrayList<CertificateData>();
                if (mssCert.getX509Certificate() != null && mssCert.getX509Certificate().size() > 0) {
                    userCertificate.setCertificateAsBase64(mssCert.getX509Certificate().get(0));
                    for (index = 1; index < mssCert.getX509Certificate().size(); ++index) {
                        certificateData = new CertificateData();
                        certificateData.setCertificateAsBase64(mssCert.getX509Certificate().get(index));
                        caCertificates.add(certificateData);
                    }
                }
                if (mssCert.getX509SubjectName() != null && mssCert.getX509SubjectName().size() > 0) {
                    userCertificate.setSubjectName(mssCert.getX509SubjectName().get(0));
                    for (index = 1; index < mssCert.getX509SubjectName().size(); ++index) {
                        if (index - 1 < caCertificates.size()) {
                            certificateData = (CertificateData)caCertificates.get(index - 1);
                        } else {
                            certificateData = new CertificateData();
                            caCertificates.add(certificateData);
                        }
                        certificateData.setSubjectName(mssCert.getX509SubjectName().get(index));
                    }
                }
                cert.setUserCertificate(userCertificate);
                cert.setCaCertificates(caCertificates);
                deviceInfo.getCertificates().add(cert);
            }
        }
        return deviceInfo;
    }
}

